package zio.aws.sms.model
import zio.aws.sms.model.primitives.{
  ReplicationJobTerminated,
  ReplicationJobId,
  ServerId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Server(
    serverId: Optional[ServerId] = Optional.Absent,
    serverType: Optional[zio.aws.sms.model.ServerType] = Optional.Absent,
    vmServer: Optional[zio.aws.sms.model.VmServer] = Optional.Absent,
    replicationJobId: Optional[ReplicationJobId] = Optional.Absent,
    replicationJobTerminated: Optional[ReplicationJobTerminated] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.sms.model.Server = {
    import Server.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.Server
      .builder()
      .optionallyWith(
        serverId.map(value => ServerId.unwrap(value): java.lang.String)
      )(_.serverId)
      .optionallyWith(serverType.map(value => value.unwrap))(_.serverType)
      .optionallyWith(vmServer.map(value => value.buildAwsValue()))(_.vmServer)
      .optionallyWith(
        replicationJobId.map(value =>
          ReplicationJobId.unwrap(value): java.lang.String
        )
      )(_.replicationJobId)
      .optionallyWith(
        replicationJobTerminated.map(value =>
          ReplicationJobTerminated.unwrap(value): java.lang.Boolean
        )
      )(_.replicationJobTerminated)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.Server.ReadOnly =
    zio.aws.sms.model.Server.wrap(buildAwsValue())
}
object Server {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sms.model.Server] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.Server = zio.aws.sms.model.Server(
      serverId.map(value => value),
      serverType.map(value => value),
      vmServer.map(value => value.asEditable),
      replicationJobId.map(value => value),
      replicationJobTerminated.map(value => value)
    )
    def serverId: Optional[ServerId]
    def serverType: Optional[zio.aws.sms.model.ServerType]
    def vmServer: Optional[zio.aws.sms.model.VmServer.ReadOnly]
    def replicationJobId: Optional[ReplicationJobId]
    def replicationJobTerminated: Optional[ReplicationJobTerminated]
    def getServerId: ZIO[Any, AwsError, ServerId] =
      AwsError.unwrapOptionField("serverId", serverId)
    def getServerType: ZIO[Any, AwsError, zio.aws.sms.model.ServerType] =
      AwsError.unwrapOptionField("serverType", serverType)
    def getVmServer: ZIO[Any, AwsError, zio.aws.sms.model.VmServer.ReadOnly] =
      AwsError.unwrapOptionField("vmServer", vmServer)
    def getReplicationJobId: ZIO[Any, AwsError, ReplicationJobId] =
      AwsError.unwrapOptionField("replicationJobId", replicationJobId)
    def getReplicationJobTerminated
        : ZIO[Any, AwsError, ReplicationJobTerminated] = AwsError
      .unwrapOptionField("replicationJobTerminated", replicationJobTerminated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.Server
  ) extends zio.aws.sms.model.Server.ReadOnly {
    override val serverId: Optional[ServerId] = zio.aws.core.internal
      .optionalFromNullable(impl.serverId())
      .map(value => zio.aws.sms.model.primitives.ServerId(value))
    override val serverType: Optional[zio.aws.sms.model.ServerType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverType())
        .map(value => zio.aws.sms.model.ServerType.wrap(value))
    override val vmServer: Optional[zio.aws.sms.model.VmServer.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vmServer())
        .map(value => zio.aws.sms.model.VmServer.wrap(value))
    override val replicationJobId: Optional[ReplicationJobId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationJobId())
        .map(value => zio.aws.sms.model.primitives.ReplicationJobId(value))
    override val replicationJobTerminated: Optional[ReplicationJobTerminated] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationJobTerminated())
        .map(value =>
          zio.aws.sms.model.primitives.ReplicationJobTerminated(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.Server
  ): zio.aws.sms.model.Server.ReadOnly = new Wrapper(impl)
}
