package zio.aws.sms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ServerReplicationConfiguration(
    server: Optional[zio.aws.sms.model.Server] = Optional.Absent,
    serverReplicationParameters: Optional[
      zio.aws.sms.model.ServerReplicationParameters
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.ServerReplicationConfiguration = {
    import ServerReplicationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.ServerReplicationConfiguration
      .builder()
      .optionallyWith(server.map(value => value.buildAwsValue()))(_.server)
      .optionallyWith(
        serverReplicationParameters.map(value => value.buildAwsValue())
      )(_.serverReplicationParameters)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.ServerReplicationConfiguration.ReadOnly =
    zio.aws.sms.model.ServerReplicationConfiguration.wrap(buildAwsValue())
}
object ServerReplicationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.ServerReplicationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.ServerReplicationConfiguration =
      zio.aws.sms.model.ServerReplicationConfiguration(
        server.map(value => value.asEditable),
        serverReplicationParameters.map(value => value.asEditable)
      )
    def server: Optional[zio.aws.sms.model.Server.ReadOnly]
    def serverReplicationParameters
        : Optional[zio.aws.sms.model.ServerReplicationParameters.ReadOnly]
    def getServer: ZIO[Any, AwsError, zio.aws.sms.model.Server.ReadOnly] =
      AwsError.unwrapOptionField("server", server)
    def getServerReplicationParameters: ZIO[
      Any,
      AwsError,
      zio.aws.sms.model.ServerReplicationParameters.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serverReplicationParameters",
      serverReplicationParameters
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.ServerReplicationConfiguration
  ) extends zio.aws.sms.model.ServerReplicationConfiguration.ReadOnly {
    override val server: Optional[zio.aws.sms.model.Server.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.server())
        .map(value => zio.aws.sms.model.Server.wrap(value))
    override val serverReplicationParameters
        : Optional[zio.aws.sms.model.ServerReplicationParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverReplicationParameters())
        .map(value => zio.aws.sms.model.ServerReplicationParameters.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.ServerReplicationConfiguration
  ): zio.aws.sms.model.ServerReplicationConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
