package zio.aws.sms.model
import scala.jdk.CollectionConverters._
sealed trait ServerType {
  def unwrap: software.amazon.awssdk.services.sms.model.ServerType
}
object ServerType {
  def wrap(
      value: software.amazon.awssdk.services.sms.model.ServerType
  ): zio.aws.sms.model.ServerType = value match {
    case software.amazon.awssdk.services.sms.model.ServerType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sms.model.ServerType.VIRTUAL_MACHINE =>
      val r = VIRTUAL_MACHINE
      r
  }
  case object unknownToSdkVersion extends zio.aws.sms.model.ServerType {
    override def unwrap: software.amazon.awssdk.services.sms.model.ServerType =
      software.amazon.awssdk.services.sms.model.ServerType.UNKNOWN_TO_SDK_VERSION
  }
  case object VIRTUAL_MACHINE extends zio.aws.sms.model.ServerType {
    override def unwrap: software.amazon.awssdk.services.sms.model.ServerType =
      software.amazon.awssdk.services.sms.model.ServerType.VIRTUAL_MACHINE
  }
}
