package zio.aws.sms.model
import zio.aws.sms.model.primitives.ReplicationRunId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartOnDemandReplicationRunResponse(
    replicationRunId: Optional[ReplicationRunId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.StartOnDemandReplicationRunResponse = {
    import StartOnDemandReplicationRunResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.StartOnDemandReplicationRunResponse
      .builder()
      .optionallyWith(
        replicationRunId.map(value =>
          ReplicationRunId.unwrap(value): java.lang.String
        )
      )(_.replicationRunId)
      .build()
  }
  def asReadOnly
      : zio.aws.sms.model.StartOnDemandReplicationRunResponse.ReadOnly =
    zio.aws.sms.model.StartOnDemandReplicationRunResponse.wrap(buildAwsValue())
}
object StartOnDemandReplicationRunResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.StartOnDemandReplicationRunResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.StartOnDemandReplicationRunResponse =
      zio.aws.sms.model.StartOnDemandReplicationRunResponse(
        replicationRunId.map(value => value)
      )
    def replicationRunId: Optional[ReplicationRunId]
    def getReplicationRunId: ZIO[Any, AwsError, ReplicationRunId] =
      AwsError.unwrapOptionField("replicationRunId", replicationRunId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.StartOnDemandReplicationRunResponse
  ) extends zio.aws.sms.model.StartOnDemandReplicationRunResponse.ReadOnly {
    override val replicationRunId: Optional[ReplicationRunId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationRunId())
        .map(value => zio.aws.sms.model.primitives.ReplicationRunId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.StartOnDemandReplicationRunResponse
  ): zio.aws.sms.model.StartOnDemandReplicationRunResponse.ReadOnly =
    new Wrapper(impl)
}
