package zio.aws.sms.model
import zio.aws.sms.model.primitives.{VmId, VmManagerId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VmServerAddress(
    vmManagerId: Optional[VmManagerId] = Optional.Absent,
    vmId: Optional[VmId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.VmServerAddress = {
    import VmServerAddress.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.VmServerAddress
      .builder()
      .optionallyWith(
        vmManagerId.map(value => VmManagerId.unwrap(value): java.lang.String)
      )(_.vmManagerId)
      .optionallyWith(vmId.map(value => VmId.unwrap(value): java.lang.String))(
        _.vmId
      )
      .build()
  }
  def asReadOnly: zio.aws.sms.model.VmServerAddress.ReadOnly =
    zio.aws.sms.model.VmServerAddress.wrap(buildAwsValue())
}
object VmServerAddress {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.VmServerAddress
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.VmServerAddress =
      zio.aws.sms.model.VmServerAddress(
        vmManagerId.map(value => value),
        vmId.map(value => value)
      )
    def vmManagerId: Optional[VmManagerId]
    def vmId: Optional[VmId]
    def getVmManagerId: ZIO[Any, AwsError, VmManagerId] =
      AwsError.unwrapOptionField("vmManagerId", vmManagerId)
    def getVmId: ZIO[Any, AwsError, VmId] =
      AwsError.unwrapOptionField("vmId", vmId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.VmServerAddress
  ) extends zio.aws.sms.model.VmServerAddress.ReadOnly {
    override val vmManagerId: Optional[VmManagerId] = zio.aws.core.internal
      .optionalFromNullable(impl.vmManagerId())
      .map(value => zio.aws.sms.model.primitives.VmManagerId(value))
    override val vmId: Optional[VmId] = zio.aws.core.internal
      .optionalFromNullable(impl.vmId())
      .map(value => zio.aws.sms.model.primitives.VmId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.VmServerAddress
  ): zio.aws.sms.model.VmServerAddress.ReadOnly = new Wrapper(impl)
}
