package zio.aws.snowball
import zio.aws.snowball.model.GetSnowballUsageResponse.ReadOnly
import zio.aws.snowball.model.{
  GetJobManifestRequest,
  DescribeReturnShippingLabelRequest,
  UpdateClusterRequest,
  ListClusterJobsRequest,
  CancelJobRequest,
  CancelClusterRequest,
  ListJobsRequest,
  DescribeJobRequest,
  CreateAddressRequest,
  CreateClusterRequest,
  GetSoftwareUpdatesRequest,
  DescribeAddressesRequest,
  GetJobUnlockCodeRequest,
  ListLongTermPricingRequest,
  ListCompatibleImagesRequest,
  DescribeAddressRequest,
  CreateReturnShippingLabelRequest,
  GetSnowballUsageRequest,
  CreateJobRequest,
  UpdateJobRequest,
  DescribeClusterRequest,
  CreateLongTermPricingRequest,
  UpdateJobShipmentStateRequest,
  ListClustersRequest,
  UpdateLongTermPricingRequest
}
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.snowball.{
  SnowballAsyncClientBuilder,
  SnowballAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.snowball.model.{
  GetJobManifestResponse,
  ListCompatibleImagesResponse,
  CancelClusterResponse,
  GetSoftwareUpdatesResponse,
  DescribeReturnShippingLabelResponse,
  GetSnowballUsageResponse,
  DescribeAddressesResponse,
  CreateLongTermPricingResponse,
  CancelJobResponse,
  CompatibleImage,
  DescribeJobResponse,
  DescribeClusterResponse,
  UpdateJobResponse,
  CreateClusterResponse,
  ClusterListEntry,
  DescribeAddressResponse,
  LongTermPricingListEntry,
  GetJobUnlockCodeResponse,
  UpdateLongTermPricingResponse,
  CreateAddressResponse,
  Address,
  ListJobsResponse,
  ListLongTermPricingResponse,
  JobListEntry,
  ListClusterJobsResponse,
  UpdateJobShipmentStateResponse,
  ListClustersResponse,
  CreateReturnShippingLabelResponse,
  CreateJobResponse,
  UpdateClusterResponse
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait Snowball extends AspectSupport[Snowball] {
  val api: SnowballAsyncClient
  def describeJob(
      request: DescribeJobRequest
  ): IO[AwsError, zio.aws.snowball.model.DescribeJobResponse.ReadOnly]
  def describeAddresses(
      request: DescribeAddressesRequest
  ): ZStream[Any, AwsError, zio.aws.snowball.model.Address.ReadOnly]
  def describeAddressesPaginated(
      request: DescribeAddressesRequest
  ): IO[AwsError, zio.aws.snowball.model.DescribeAddressesResponse.ReadOnly]
  def getJobUnlockCode(
      request: GetJobUnlockCodeRequest
  ): IO[AwsError, zio.aws.snowball.model.GetJobUnlockCodeResponse.ReadOnly]
  def getSnowballUsage(request: GetSnowballUsageRequest): IO[AwsError, ReadOnly]
  def describeAddress(
      request: DescribeAddressRequest
  ): IO[AwsError, zio.aws.snowball.model.DescribeAddressResponse.ReadOnly]
  def createJob(
      request: CreateJobRequest
  ): IO[AwsError, zio.aws.snowball.model.CreateJobResponse.ReadOnly]
  def createLongTermPricing(
      request: CreateLongTermPricingRequest
  ): IO[AwsError, zio.aws.snowball.model.CreateLongTermPricingResponse.ReadOnly]
  def createCluster(
      request: CreateClusterRequest
  ): IO[AwsError, zio.aws.snowball.model.CreateClusterResponse.ReadOnly]
  def cancelJob(
      request: CancelJobRequest
  ): IO[AwsError, zio.aws.snowball.model.CancelJobResponse.ReadOnly]
  def createReturnShippingLabel(request: CreateReturnShippingLabelRequest): IO[
    AwsError,
    zio.aws.snowball.model.CreateReturnShippingLabelResponse.ReadOnly
  ]
  def updateCluster(
      request: UpdateClusterRequest
  ): IO[AwsError, zio.aws.snowball.model.UpdateClusterResponse.ReadOnly]
  def createAddress(
      request: CreateAddressRequest
  ): IO[AwsError, zio.aws.snowball.model.CreateAddressResponse.ReadOnly]
  def getSoftwareUpdates(
      request: GetSoftwareUpdatesRequest
  ): IO[AwsError, zio.aws.snowball.model.GetSoftwareUpdatesResponse.ReadOnly]
  def describeReturnShippingLabel(
      request: DescribeReturnShippingLabelRequest
  ): IO[
    AwsError,
    zio.aws.snowball.model.DescribeReturnShippingLabelResponse.ReadOnly
  ]
  def listLongTermPricing(request: ListLongTermPricingRequest): ZStream[
    Any,
    AwsError,
    zio.aws.snowball.model.LongTermPricingListEntry.ReadOnly
  ]
  def listLongTermPricingPaginated(
      request: ListLongTermPricingRequest
  ): IO[AwsError, zio.aws.snowball.model.ListLongTermPricingResponse.ReadOnly]
  def cancelCluster(
      request: CancelClusterRequest
  ): IO[AwsError, zio.aws.snowball.model.CancelClusterResponse.ReadOnly]
  def getJobManifest(
      request: GetJobManifestRequest
  ): IO[AwsError, zio.aws.snowball.model.GetJobManifestResponse.ReadOnly]
  def updateJob(
      request: UpdateJobRequest
  ): IO[AwsError, zio.aws.snowball.model.UpdateJobResponse.ReadOnly]
  def updateJobShipmentState(request: UpdateJobShipmentStateRequest): IO[
    AwsError,
    zio.aws.snowball.model.UpdateJobShipmentStateResponse.ReadOnly
  ]
  def describeCluster(
      request: DescribeClusterRequest
  ): IO[AwsError, zio.aws.snowball.model.DescribeClusterResponse.ReadOnly]
  def listClusters(
      request: ListClustersRequest
  ): ZStream[Any, AwsError, zio.aws.snowball.model.ClusterListEntry.ReadOnly]
  def listClustersPaginated(
      request: ListClustersRequest
  ): IO[AwsError, zio.aws.snowball.model.ListClustersResponse.ReadOnly]
  def listJobs(
      request: ListJobsRequest
  ): ZStream[Any, AwsError, zio.aws.snowball.model.JobListEntry.ReadOnly]
  def listJobsPaginated(
      request: ListJobsRequest
  ): IO[AwsError, zio.aws.snowball.model.ListJobsResponse.ReadOnly]
  def updateLongTermPricing(
      request: UpdateLongTermPricingRequest
  ): IO[AwsError, zio.aws.snowball.model.UpdateLongTermPricingResponse.ReadOnly]
  def listCompatibleImages(
      request: ListCompatibleImagesRequest
  ): ZStream[Any, AwsError, zio.aws.snowball.model.CompatibleImage.ReadOnly]
  def listCompatibleImagesPaginated(
      request: ListCompatibleImagesRequest
  ): IO[AwsError, zio.aws.snowball.model.ListCompatibleImagesResponse.ReadOnly]
  def listClusterJobs(
      request: ListClusterJobsRequest
  ): ZStream[Any, AwsError, zio.aws.snowball.model.JobListEntry.ReadOnly]
  def listClusterJobsPaginated(
      request: ListClusterJobsRequest
  ): IO[AwsError, zio.aws.snowball.model.ListClusterJobsResponse.ReadOnly]
}
object Snowball {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Snowball] = customized(
    identity
  )
  def customized(
      customization: SnowballAsyncClientBuilder => SnowballAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Snowball] = managed(
    customization
  ).toLayer
  def managed(
      customization: SnowballAsyncClientBuilder => SnowballAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Snowball] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = SnowballAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[SnowballAsyncClient, SnowballAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[SnowballAsyncClient, SnowballAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new SnowballImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class SnowballImpl[R](
      override val api: SnowballAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Snowball
      with AwsServiceBase[R] {
    override val serviceName: String = "Snowball"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): SnowballImpl[R1] = new SnowballImpl(api, newAspect, r)
    def describeJob(
        request: DescribeJobRequest
    ): IO[AwsError, zio.aws.snowball.model.DescribeJobResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.snowball.model.DescribeJobRequest,
        DescribeJobResponse
      ]("describeJob", api.describeJob)(request.buildAwsValue())
        .map(zio.aws.snowball.model.DescribeJobResponse.wrap)
        .provideEnvironment(r)
    def describeAddresses(
        request: DescribeAddressesRequest
    ): ZStream[Any, AwsError, zio.aws.snowball.model.Address.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.snowball.model.DescribeAddressesRequest,
        DescribeAddressesResponse,
        Address
      ](
        "describeAddresses",
        api.describeAddresses,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.addresses().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.snowball.model.Address.wrap(item))
        .provideEnvironment(r)
    def describeAddressesPaginated(
        request: DescribeAddressesRequest
    ): IO[AwsError, zio.aws.snowball.model.DescribeAddressesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.snowball.model.DescribeAddressesRequest,
        DescribeAddressesResponse
      ]("describeAddresses", api.describeAddresses)(request.buildAwsValue())
        .map(zio.aws.snowball.model.DescribeAddressesResponse.wrap)
        .provideEnvironment(r)
    def getJobUnlockCode(
        request: GetJobUnlockCodeRequest
    ): IO[AwsError, zio.aws.snowball.model.GetJobUnlockCodeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.snowball.model.GetJobUnlockCodeRequest,
        GetJobUnlockCodeResponse
      ]("getJobUnlockCode", api.getJobUnlockCode)(request.buildAwsValue())
        .map(zio.aws.snowball.model.GetJobUnlockCodeResponse.wrap)
        .provideEnvironment(r)
    def getSnowballUsage(
        request: GetSnowballUsageRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.snowball.model.GetSnowballUsageRequest,
      GetSnowballUsageResponse
    ]("getSnowballUsage", api.getSnowballUsage)(request.buildAwsValue())
      .map(zio.aws.snowball.model.GetSnowballUsageResponse.wrap)
      .provideEnvironment(r)
    def describeAddress(
        request: DescribeAddressRequest
    ): IO[AwsError, zio.aws.snowball.model.DescribeAddressResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.snowball.model.DescribeAddressRequest,
        DescribeAddressResponse
      ]("describeAddress", api.describeAddress)(request.buildAwsValue())
        .map(zio.aws.snowball.model.DescribeAddressResponse.wrap)
        .provideEnvironment(r)
    def createJob(
        request: CreateJobRequest
    ): IO[AwsError, zio.aws.snowball.model.CreateJobResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.snowball.model.CreateJobRequest,
        CreateJobResponse
      ]("createJob", api.createJob)(request.buildAwsValue())
        .map(zio.aws.snowball.model.CreateJobResponse.wrap)
        .provideEnvironment(r)
    def createLongTermPricing(request: CreateLongTermPricingRequest): IO[
      AwsError,
      zio.aws.snowball.model.CreateLongTermPricingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.snowball.model.CreateLongTermPricingRequest,
      CreateLongTermPricingResponse
    ]("createLongTermPricing", api.createLongTermPricing)(
      request.buildAwsValue()
    ).map(zio.aws.snowball.model.CreateLongTermPricingResponse.wrap)
      .provideEnvironment(r)
    def createCluster(
        request: CreateClusterRequest
    ): IO[AwsError, zio.aws.snowball.model.CreateClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.snowball.model.CreateClusterRequest,
        CreateClusterResponse
      ]("createCluster", api.createCluster)(request.buildAwsValue())
        .map(zio.aws.snowball.model.CreateClusterResponse.wrap)
        .provideEnvironment(r)
    def cancelJob(
        request: CancelJobRequest
    ): IO[AwsError, zio.aws.snowball.model.CancelJobResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.snowball.model.CancelJobRequest,
        CancelJobResponse
      ]("cancelJob", api.cancelJob)(request.buildAwsValue())
        .map(zio.aws.snowball.model.CancelJobResponse.wrap)
        .provideEnvironment(r)
    def createReturnShippingLabel(
        request: CreateReturnShippingLabelRequest
    ): IO[
      AwsError,
      zio.aws.snowball.model.CreateReturnShippingLabelResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.snowball.model.CreateReturnShippingLabelRequest,
      CreateReturnShippingLabelResponse
    ]("createReturnShippingLabel", api.createReturnShippingLabel)(
      request.buildAwsValue()
    ).map(zio.aws.snowball.model.CreateReturnShippingLabelResponse.wrap)
      .provideEnvironment(r)
    def updateCluster(
        request: UpdateClusterRequest
    ): IO[AwsError, zio.aws.snowball.model.UpdateClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.snowball.model.UpdateClusterRequest,
        UpdateClusterResponse
      ]("updateCluster", api.updateCluster)(request.buildAwsValue())
        .map(zio.aws.snowball.model.UpdateClusterResponse.wrap)
        .provideEnvironment(r)
    def createAddress(
        request: CreateAddressRequest
    ): IO[AwsError, zio.aws.snowball.model.CreateAddressResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.snowball.model.CreateAddressRequest,
        CreateAddressResponse
      ]("createAddress", api.createAddress)(request.buildAwsValue())
        .map(zio.aws.snowball.model.CreateAddressResponse.wrap)
        .provideEnvironment(r)
    def getSoftwareUpdates(request: GetSoftwareUpdatesRequest): IO[
      AwsError,
      zio.aws.snowball.model.GetSoftwareUpdatesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.snowball.model.GetSoftwareUpdatesRequest,
      GetSoftwareUpdatesResponse
    ]("getSoftwareUpdates", api.getSoftwareUpdates)(request.buildAwsValue())
      .map(zio.aws.snowball.model.GetSoftwareUpdatesResponse.wrap)
      .provideEnvironment(r)
    def describeReturnShippingLabel(
        request: DescribeReturnShippingLabelRequest
    ): IO[
      AwsError,
      zio.aws.snowball.model.DescribeReturnShippingLabelResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.snowball.model.DescribeReturnShippingLabelRequest,
      DescribeReturnShippingLabelResponse
    ]("describeReturnShippingLabel", api.describeReturnShippingLabel)(
      request.buildAwsValue()
    ).map(zio.aws.snowball.model.DescribeReturnShippingLabelResponse.wrap)
      .provideEnvironment(r)
    def listLongTermPricing(request: ListLongTermPricingRequest): ZStream[
      Any,
      AwsError,
      zio.aws.snowball.model.LongTermPricingListEntry.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.snowball.model.ListLongTermPricingRequest,
      ListLongTermPricingResponse,
      LongTermPricingListEntry
    ](
      "listLongTermPricing",
      api.listLongTermPricing,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.longTermPricingEntries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.snowball.model.LongTermPricingListEntry.wrap(item))
      .provideEnvironment(r)
    def listLongTermPricingPaginated(request: ListLongTermPricingRequest): IO[
      AwsError,
      zio.aws.snowball.model.ListLongTermPricingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.snowball.model.ListLongTermPricingRequest,
      ListLongTermPricingResponse
    ]("listLongTermPricing", api.listLongTermPricing)(request.buildAwsValue())
      .map(zio.aws.snowball.model.ListLongTermPricingResponse.wrap)
      .provideEnvironment(r)
    def cancelCluster(
        request: CancelClusterRequest
    ): IO[AwsError, zio.aws.snowball.model.CancelClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.snowball.model.CancelClusterRequest,
        CancelClusterResponse
      ]("cancelCluster", api.cancelCluster)(request.buildAwsValue())
        .map(zio.aws.snowball.model.CancelClusterResponse.wrap)
        .provideEnvironment(r)
    def getJobManifest(
        request: GetJobManifestRequest
    ): IO[AwsError, zio.aws.snowball.model.GetJobManifestResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.snowball.model.GetJobManifestRequest,
        GetJobManifestResponse
      ]("getJobManifest", api.getJobManifest)(request.buildAwsValue())
        .map(zio.aws.snowball.model.GetJobManifestResponse.wrap)
        .provideEnvironment(r)
    def updateJob(
        request: UpdateJobRequest
    ): IO[AwsError, zio.aws.snowball.model.UpdateJobResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.snowball.model.UpdateJobRequest,
        UpdateJobResponse
      ]("updateJob", api.updateJob)(request.buildAwsValue())
        .map(zio.aws.snowball.model.UpdateJobResponse.wrap)
        .provideEnvironment(r)
    def updateJobShipmentState(request: UpdateJobShipmentStateRequest): IO[
      AwsError,
      zio.aws.snowball.model.UpdateJobShipmentStateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.snowball.model.UpdateJobShipmentStateRequest,
      UpdateJobShipmentStateResponse
    ]("updateJobShipmentState", api.updateJobShipmentState)(
      request.buildAwsValue()
    ).map(zio.aws.snowball.model.UpdateJobShipmentStateResponse.wrap)
      .provideEnvironment(r)
    def describeCluster(
        request: DescribeClusterRequest
    ): IO[AwsError, zio.aws.snowball.model.DescribeClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.snowball.model.DescribeClusterRequest,
        DescribeClusterResponse
      ]("describeCluster", api.describeCluster)(request.buildAwsValue())
        .map(zio.aws.snowball.model.DescribeClusterResponse.wrap)
        .provideEnvironment(r)
    def listClusters(request: ListClustersRequest): ZStream[
      Any,
      AwsError,
      zio.aws.snowball.model.ClusterListEntry.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.snowball.model.ListClustersRequest,
      ListClustersResponse,
      ClusterListEntry
    ](
      "listClusters",
      api.listClusters,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.clusterListEntries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.snowball.model.ClusterListEntry.wrap(item))
      .provideEnvironment(r)
    def listClustersPaginated(
        request: ListClustersRequest
    ): IO[AwsError, zio.aws.snowball.model.ListClustersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.snowball.model.ListClustersRequest,
        ListClustersResponse
      ]("listClusters", api.listClusters)(request.buildAwsValue())
        .map(zio.aws.snowball.model.ListClustersResponse.wrap)
        .provideEnvironment(r)
    def listJobs(
        request: ListJobsRequest
    ): ZStream[Any, AwsError, zio.aws.snowball.model.JobListEntry.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.snowball.model.ListJobsRequest,
        ListJobsResponse,
        JobListEntry
      ](
        "listJobs",
        api.listJobs,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.jobListEntries().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.snowball.model.JobListEntry.wrap(item))
        .provideEnvironment(r)
    def listJobsPaginated(
        request: ListJobsRequest
    ): IO[AwsError, zio.aws.snowball.model.ListJobsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.snowball.model.ListJobsRequest,
        ListJobsResponse
      ]("listJobs", api.listJobs)(request.buildAwsValue())
        .map(zio.aws.snowball.model.ListJobsResponse.wrap)
        .provideEnvironment(r)
    def updateLongTermPricing(request: UpdateLongTermPricingRequest): IO[
      AwsError,
      zio.aws.snowball.model.UpdateLongTermPricingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.snowball.model.UpdateLongTermPricingRequest,
      UpdateLongTermPricingResponse
    ]("updateLongTermPricing", api.updateLongTermPricing)(
      request.buildAwsValue()
    ).map(zio.aws.snowball.model.UpdateLongTermPricingResponse.wrap)
      .provideEnvironment(r)
    def listCompatibleImages(request: ListCompatibleImagesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.snowball.model.CompatibleImage.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.snowball.model.ListCompatibleImagesRequest,
      ListCompatibleImagesResponse,
      CompatibleImage
    ](
      "listCompatibleImages",
      api.listCompatibleImages,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.compatibleImages().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.snowball.model.CompatibleImage.wrap(item))
      .provideEnvironment(r)
    def listCompatibleImagesPaginated(request: ListCompatibleImagesRequest): IO[
      AwsError,
      zio.aws.snowball.model.ListCompatibleImagesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.snowball.model.ListCompatibleImagesRequest,
      ListCompatibleImagesResponse
    ]("listCompatibleImages", api.listCompatibleImages)(request.buildAwsValue())
      .map(zio.aws.snowball.model.ListCompatibleImagesResponse.wrap)
      .provideEnvironment(r)
    def listClusterJobs(
        request: ListClusterJobsRequest
    ): ZStream[Any, AwsError, zio.aws.snowball.model.JobListEntry.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.snowball.model.ListClusterJobsRequest,
        ListClusterJobsResponse,
        JobListEntry
      ](
        "listClusterJobs",
        api.listClusterJobs,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.jobListEntries().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.snowball.model.JobListEntry.wrap(item))
        .provideEnvironment(r)
    def listClusterJobsPaginated(
        request: ListClusterJobsRequest
    ): IO[AwsError, zio.aws.snowball.model.ListClusterJobsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.snowball.model.ListClusterJobsRequest,
        ListClusterJobsResponse
      ]("listClusterJobs", api.listClusterJobs)(request.buildAwsValue())
        .map(zio.aws.snowball.model.ListClusterJobsResponse.wrap)
        .provideEnvironment(r)
  }
  def describeJob(request: DescribeJobRequest): ZIO[
    zio.aws.snowball.Snowball,
    AwsError,
    zio.aws.snowball.model.DescribeJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeJob(request))
  def describeAddresses(request: DescribeAddressesRequest): ZStream[
    zio.aws.snowball.Snowball,
    AwsError,
    zio.aws.snowball.model.Address.ReadOnly
  ] = ZStream.serviceWithStream(_.describeAddresses(request))
  def describeAddressesPaginated(request: DescribeAddressesRequest): ZIO[
    zio.aws.snowball.Snowball,
    AwsError,
    zio.aws.snowball.model.DescribeAddressesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAddressesPaginated(request))
  def getJobUnlockCode(request: GetJobUnlockCodeRequest): ZIO[
    zio.aws.snowball.Snowball,
    AwsError,
    zio.aws.snowball.model.GetJobUnlockCodeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getJobUnlockCode(request))
  def getSnowballUsage(
      request: GetSnowballUsageRequest
  ): ZIO[zio.aws.snowball.Snowball, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getSnowballUsage(request))
  def describeAddress(request: DescribeAddressRequest): ZIO[
    zio.aws.snowball.Snowball,
    AwsError,
    zio.aws.snowball.model.DescribeAddressResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAddress(request))
  def createJob(request: CreateJobRequest): ZIO[
    zio.aws.snowball.Snowball,
    AwsError,
    zio.aws.snowball.model.CreateJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createJob(request))
  def createLongTermPricing(request: CreateLongTermPricingRequest): ZIO[
    zio.aws.snowball.Snowball,
    AwsError,
    zio.aws.snowball.model.CreateLongTermPricingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLongTermPricing(request))
  def createCluster(request: CreateClusterRequest): ZIO[
    zio.aws.snowball.Snowball,
    AwsError,
    zio.aws.snowball.model.CreateClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCluster(request))
  def cancelJob(request: CancelJobRequest): ZIO[
    zio.aws.snowball.Snowball,
    AwsError,
    zio.aws.snowball.model.CancelJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelJob(request))
  def createReturnShippingLabel(request: CreateReturnShippingLabelRequest): ZIO[
    zio.aws.snowball.Snowball,
    AwsError,
    zio.aws.snowball.model.CreateReturnShippingLabelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createReturnShippingLabel(request))
  def updateCluster(request: UpdateClusterRequest): ZIO[
    zio.aws.snowball.Snowball,
    AwsError,
    zio.aws.snowball.model.UpdateClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateCluster(request))
  def createAddress(request: CreateAddressRequest): ZIO[
    zio.aws.snowball.Snowball,
    AwsError,
    zio.aws.snowball.model.CreateAddressResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAddress(request))
  def getSoftwareUpdates(request: GetSoftwareUpdatesRequest): ZIO[
    zio.aws.snowball.Snowball,
    AwsError,
    zio.aws.snowball.model.GetSoftwareUpdatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSoftwareUpdates(request))
  def describeReturnShippingLabel(
      request: DescribeReturnShippingLabelRequest
  ): ZIO[
    zio.aws.snowball.Snowball,
    AwsError,
    zio.aws.snowball.model.DescribeReturnShippingLabelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReturnShippingLabel(request))
  def listLongTermPricing(request: ListLongTermPricingRequest): ZStream[
    zio.aws.snowball.Snowball,
    AwsError,
    zio.aws.snowball.model.LongTermPricingListEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listLongTermPricing(request))
  def listLongTermPricingPaginated(request: ListLongTermPricingRequest): ZIO[
    zio.aws.snowball.Snowball,
    AwsError,
    zio.aws.snowball.model.ListLongTermPricingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLongTermPricingPaginated(request))
  def cancelCluster(request: CancelClusterRequest): ZIO[
    zio.aws.snowball.Snowball,
    AwsError,
    zio.aws.snowball.model.CancelClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelCluster(request))
  def getJobManifest(request: GetJobManifestRequest): ZIO[
    zio.aws.snowball.Snowball,
    AwsError,
    zio.aws.snowball.model.GetJobManifestResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getJobManifest(request))
  def updateJob(request: UpdateJobRequest): ZIO[
    zio.aws.snowball.Snowball,
    AwsError,
    zio.aws.snowball.model.UpdateJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateJob(request))
  def updateJobShipmentState(request: UpdateJobShipmentStateRequest): ZIO[
    zio.aws.snowball.Snowball,
    AwsError,
    zio.aws.snowball.model.UpdateJobShipmentStateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateJobShipmentState(request))
  def describeCluster(request: DescribeClusterRequest): ZIO[
    zio.aws.snowball.Snowball,
    AwsError,
    zio.aws.snowball.model.DescribeClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCluster(request))
  def listClusters(request: ListClustersRequest): ZStream[
    zio.aws.snowball.Snowball,
    AwsError,
    zio.aws.snowball.model.ClusterListEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listClusters(request))
  def listClustersPaginated(request: ListClustersRequest): ZIO[
    zio.aws.snowball.Snowball,
    AwsError,
    zio.aws.snowball.model.ListClustersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listClustersPaginated(request))
  def listJobs(request: ListJobsRequest): ZStream[
    zio.aws.snowball.Snowball,
    AwsError,
    zio.aws.snowball.model.JobListEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listJobs(request))
  def listJobsPaginated(request: ListJobsRequest): ZIO[
    zio.aws.snowball.Snowball,
    AwsError,
    zio.aws.snowball.model.ListJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listJobsPaginated(request))
  def updateLongTermPricing(request: UpdateLongTermPricingRequest): ZIO[
    zio.aws.snowball.Snowball,
    AwsError,
    zio.aws.snowball.model.UpdateLongTermPricingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateLongTermPricing(request))
  def listCompatibleImages(request: ListCompatibleImagesRequest): ZStream[
    zio.aws.snowball.Snowball,
    AwsError,
    zio.aws.snowball.model.CompatibleImage.ReadOnly
  ] = ZStream.serviceWithStream(_.listCompatibleImages(request))
  def listCompatibleImagesPaginated(request: ListCompatibleImagesRequest): ZIO[
    zio.aws.snowball.Snowball,
    AwsError,
    zio.aws.snowball.model.ListCompatibleImagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCompatibleImagesPaginated(request))
  def listClusterJobs(request: ListClusterJobsRequest): ZStream[
    zio.aws.snowball.Snowball,
    AwsError,
    zio.aws.snowball.model.JobListEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listClusterJobs(request))
  def listClusterJobsPaginated(request: ListClusterJobsRequest): ZIO[
    zio.aws.snowball.Snowball,
    AwsError,
    zio.aws.snowball.model.ListClusterJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listClusterJobsPaginated(request))
}
