package zio.aws.snowball
import zio.aws.snowball.model.GetSnowballUsageResponse.ReadOnly
import zio.aws.snowball.model.{
  GetJobManifestRequest,
  DescribeReturnShippingLabelRequest,
  UpdateClusterRequest,
  ListClusterJobsRequest,
  CancelJobRequest,
  CancelClusterRequest,
  ListJobsRequest,
  DescribeJobRequest,
  CreateAddressRequest,
  CreateClusterRequest,
  GetSoftwareUpdatesRequest,
  DescribeAddressesRequest,
  GetJobUnlockCodeRequest,
  ListLongTermPricingRequest,
  ListCompatibleImagesRequest,
  DescribeAddressRequest,
  CreateReturnShippingLabelRequest,
  GetSnowballUsageRequest,
  CreateJobRequest,
  UpdateJobRequest,
  DescribeClusterRequest,
  CreateLongTermPricingRequest,
  UpdateJobShipmentStateRequest,
  ListClustersRequest,
  UpdateLongTermPricingRequest
}
import zio.aws.core.AwsError
import software.amazon.awssdk.services.snowball.SnowballAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import zio.test.mock.{Proxy, Mock}
object SnowballMock extends Mock[Snowball] {
  object DescribeJob
      extends Effect[
        DescribeJobRequest,
        AwsError,
        zio.aws.snowball.model.DescribeJobResponse.ReadOnly
      ]
  object DescribeAddresses
      extends Stream[
        DescribeAddressesRequest,
        AwsError,
        zio.aws.snowball.model.Address.ReadOnly
      ]
  object DescribeAddressesPaginated
      extends Effect[
        DescribeAddressesRequest,
        AwsError,
        zio.aws.snowball.model.DescribeAddressesResponse.ReadOnly
      ]
  object GetJobUnlockCode
      extends Effect[
        GetJobUnlockCodeRequest,
        AwsError,
        zio.aws.snowball.model.GetJobUnlockCodeResponse.ReadOnly
      ]
  object GetSnowballUsage
      extends Effect[GetSnowballUsageRequest, AwsError, ReadOnly]
  object DescribeAddress
      extends Effect[
        DescribeAddressRequest,
        AwsError,
        zio.aws.snowball.model.DescribeAddressResponse.ReadOnly
      ]
  object CreateJob
      extends Effect[
        CreateJobRequest,
        AwsError,
        zio.aws.snowball.model.CreateJobResponse.ReadOnly
      ]
  object CreateLongTermPricing
      extends Effect[
        CreateLongTermPricingRequest,
        AwsError,
        zio.aws.snowball.model.CreateLongTermPricingResponse.ReadOnly
      ]
  object CreateCluster
      extends Effect[
        CreateClusterRequest,
        AwsError,
        zio.aws.snowball.model.CreateClusterResponse.ReadOnly
      ]
  object CancelJob
      extends Effect[
        CancelJobRequest,
        AwsError,
        zio.aws.snowball.model.CancelJobResponse.ReadOnly
      ]
  object CreateReturnShippingLabel
      extends Effect[
        CreateReturnShippingLabelRequest,
        AwsError,
        zio.aws.snowball.model.CreateReturnShippingLabelResponse.ReadOnly
      ]
  object UpdateCluster
      extends Effect[
        UpdateClusterRequest,
        AwsError,
        zio.aws.snowball.model.UpdateClusterResponse.ReadOnly
      ]
  object CreateAddress
      extends Effect[
        CreateAddressRequest,
        AwsError,
        zio.aws.snowball.model.CreateAddressResponse.ReadOnly
      ]
  object GetSoftwareUpdates
      extends Effect[
        GetSoftwareUpdatesRequest,
        AwsError,
        zio.aws.snowball.model.GetSoftwareUpdatesResponse.ReadOnly
      ]
  object DescribeReturnShippingLabel
      extends Effect[
        DescribeReturnShippingLabelRequest,
        AwsError,
        zio.aws.snowball.model.DescribeReturnShippingLabelResponse.ReadOnly
      ]
  object ListLongTermPricing
      extends Stream[
        ListLongTermPricingRequest,
        AwsError,
        zio.aws.snowball.model.LongTermPricingListEntry.ReadOnly
      ]
  object ListLongTermPricingPaginated
      extends Effect[
        ListLongTermPricingRequest,
        AwsError,
        zio.aws.snowball.model.ListLongTermPricingResponse.ReadOnly
      ]
  object CancelCluster
      extends Effect[
        CancelClusterRequest,
        AwsError,
        zio.aws.snowball.model.CancelClusterResponse.ReadOnly
      ]
  object GetJobManifest
      extends Effect[
        GetJobManifestRequest,
        AwsError,
        zio.aws.snowball.model.GetJobManifestResponse.ReadOnly
      ]
  object UpdateJob
      extends Effect[
        UpdateJobRequest,
        AwsError,
        zio.aws.snowball.model.UpdateJobResponse.ReadOnly
      ]
  object UpdateJobShipmentState
      extends Effect[
        UpdateJobShipmentStateRequest,
        AwsError,
        zio.aws.snowball.model.UpdateJobShipmentStateResponse.ReadOnly
      ]
  object DescribeCluster
      extends Effect[
        DescribeClusterRequest,
        AwsError,
        zio.aws.snowball.model.DescribeClusterResponse.ReadOnly
      ]
  object ListClusters
      extends Stream[
        ListClustersRequest,
        AwsError,
        zio.aws.snowball.model.ClusterListEntry.ReadOnly
      ]
  object ListClustersPaginated
      extends Effect[
        ListClustersRequest,
        AwsError,
        zio.aws.snowball.model.ListClustersResponse.ReadOnly
      ]
  object ListJobs
      extends Stream[
        ListJobsRequest,
        AwsError,
        zio.aws.snowball.model.JobListEntry.ReadOnly
      ]
  object ListJobsPaginated
      extends Effect[
        ListJobsRequest,
        AwsError,
        zio.aws.snowball.model.ListJobsResponse.ReadOnly
      ]
  object UpdateLongTermPricing
      extends Effect[
        UpdateLongTermPricingRequest,
        AwsError,
        zio.aws.snowball.model.UpdateLongTermPricingResponse.ReadOnly
      ]
  object ListCompatibleImages
      extends Stream[
        ListCompatibleImagesRequest,
        AwsError,
        zio.aws.snowball.model.CompatibleImage.ReadOnly
      ]
  object ListCompatibleImagesPaginated
      extends Effect[
        ListCompatibleImagesRequest,
        AwsError,
        zio.aws.snowball.model.ListCompatibleImagesResponse.ReadOnly
      ]
  object ListClusterJobs
      extends Stream[
        ListClusterJobsRequest,
        AwsError,
        zio.aws.snowball.model.JobListEntry.ReadOnly
      ]
  object ListClusterJobsPaginated
      extends Effect[
        ListClusterJobsRequest,
        AwsError,
        zio.aws.snowball.model.ListClusterJobsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Snowball] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Snowball {
          val api: SnowballAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Snowball = this
          def describeJob(
              request: DescribeJobRequest
          ): IO[AwsError, zio.aws.snowball.model.DescribeJobResponse.ReadOnly] =
            proxy(DescribeJob, request)
          def describeAddresses(
              request: DescribeAddressesRequest
          ): ZStream[Any, AwsError, zio.aws.snowball.model.Address.ReadOnly] =
            rts.unsafeRun(proxy(DescribeAddresses, request))
          def describeAddressesPaginated(request: DescribeAddressesRequest): IO[
            AwsError,
            zio.aws.snowball.model.DescribeAddressesResponse.ReadOnly
          ] = proxy(DescribeAddressesPaginated, request)
          def getJobUnlockCode(request: GetJobUnlockCodeRequest): IO[
            AwsError,
            zio.aws.snowball.model.GetJobUnlockCodeResponse.ReadOnly
          ] = proxy(GetJobUnlockCode, request)
          def getSnowballUsage(
              request: GetSnowballUsageRequest
          ): IO[AwsError, ReadOnly] = proxy(GetSnowballUsage, request)
          def describeAddress(request: DescribeAddressRequest): IO[
            AwsError,
            zio.aws.snowball.model.DescribeAddressResponse.ReadOnly
          ] = proxy(DescribeAddress, request)
          def createJob(
              request: CreateJobRequest
          ): IO[AwsError, zio.aws.snowball.model.CreateJobResponse.ReadOnly] =
            proxy(CreateJob, request)
          def createLongTermPricing(request: CreateLongTermPricingRequest): IO[
            AwsError,
            zio.aws.snowball.model.CreateLongTermPricingResponse.ReadOnly
          ] = proxy(CreateLongTermPricing, request)
          def createCluster(request: CreateClusterRequest): IO[
            AwsError,
            zio.aws.snowball.model.CreateClusterResponse.ReadOnly
          ] = proxy(CreateCluster, request)
          def cancelJob(
              request: CancelJobRequest
          ): IO[AwsError, zio.aws.snowball.model.CancelJobResponse.ReadOnly] =
            proxy(CancelJob, request)
          def createReturnShippingLabel(
              request: CreateReturnShippingLabelRequest
          ): IO[
            AwsError,
            zio.aws.snowball.model.CreateReturnShippingLabelResponse.ReadOnly
          ] = proxy(CreateReturnShippingLabel, request)
          def updateCluster(request: UpdateClusterRequest): IO[
            AwsError,
            zio.aws.snowball.model.UpdateClusterResponse.ReadOnly
          ] = proxy(UpdateCluster, request)
          def createAddress(request: CreateAddressRequest): IO[
            AwsError,
            zio.aws.snowball.model.CreateAddressResponse.ReadOnly
          ] = proxy(CreateAddress, request)
          def getSoftwareUpdates(request: GetSoftwareUpdatesRequest): IO[
            AwsError,
            zio.aws.snowball.model.GetSoftwareUpdatesResponse.ReadOnly
          ] = proxy(GetSoftwareUpdates, request)
          def describeReturnShippingLabel(
              request: DescribeReturnShippingLabelRequest
          ): IO[
            AwsError,
            zio.aws.snowball.model.DescribeReturnShippingLabelResponse.ReadOnly
          ] = proxy(DescribeReturnShippingLabel, request)
          def listLongTermPricing(request: ListLongTermPricingRequest): ZStream[
            Any,
            AwsError,
            zio.aws.snowball.model.LongTermPricingListEntry.ReadOnly
          ] = rts.unsafeRun(proxy(ListLongTermPricing, request))
          def listLongTermPricingPaginated(
              request: ListLongTermPricingRequest
          ): IO[
            AwsError,
            zio.aws.snowball.model.ListLongTermPricingResponse.ReadOnly
          ] = proxy(ListLongTermPricingPaginated, request)
          def cancelCluster(request: CancelClusterRequest): IO[
            AwsError,
            zio.aws.snowball.model.CancelClusterResponse.ReadOnly
          ] = proxy(CancelCluster, request)
          def getJobManifest(request: GetJobManifestRequest): IO[
            AwsError,
            zio.aws.snowball.model.GetJobManifestResponse.ReadOnly
          ] = proxy(GetJobManifest, request)
          def updateJob(
              request: UpdateJobRequest
          ): IO[AwsError, zio.aws.snowball.model.UpdateJobResponse.ReadOnly] =
            proxy(UpdateJob, request)
          def updateJobShipmentState(
              request: UpdateJobShipmentStateRequest
          ): IO[
            AwsError,
            zio.aws.snowball.model.UpdateJobShipmentStateResponse.ReadOnly
          ] = proxy(UpdateJobShipmentState, request)
          def describeCluster(request: DescribeClusterRequest): IO[
            AwsError,
            zio.aws.snowball.model.DescribeClusterResponse.ReadOnly
          ] = proxy(DescribeCluster, request)
          def listClusters(request: ListClustersRequest): ZStream[
            Any,
            AwsError,
            zio.aws.snowball.model.ClusterListEntry.ReadOnly
          ] = rts.unsafeRun(proxy(ListClusters, request))
          def listClustersPaginated(request: ListClustersRequest): IO[
            AwsError,
            zio.aws.snowball.model.ListClustersResponse.ReadOnly
          ] = proxy(ListClustersPaginated, request)
          def listJobs(request: ListJobsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.snowball.model.JobListEntry.ReadOnly
          ] = rts.unsafeRun(proxy(ListJobs, request))
          def listJobsPaginated(
              request: ListJobsRequest
          ): IO[AwsError, zio.aws.snowball.model.ListJobsResponse.ReadOnly] =
            proxy(ListJobsPaginated, request)
          def updateLongTermPricing(request: UpdateLongTermPricingRequest): IO[
            AwsError,
            zio.aws.snowball.model.UpdateLongTermPricingResponse.ReadOnly
          ] = proxy(UpdateLongTermPricing, request)
          def listCompatibleImages(
              request: ListCompatibleImagesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.snowball.model.CompatibleImage.ReadOnly
          ] = rts.unsafeRun(proxy(ListCompatibleImages, request))
          def listCompatibleImagesPaginated(
              request: ListCompatibleImagesRequest
          ): IO[
            AwsError,
            zio.aws.snowball.model.ListCompatibleImagesResponse.ReadOnly
          ] = proxy(ListCompatibleImagesPaginated, request)
          def listClusterJobs(request: ListClusterJobsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.snowball.model.JobListEntry.ReadOnly
          ] = rts.unsafeRun(proxy(ListClusterJobs, request))
          def listClusterJobsPaginated(request: ListClusterJobsRequest): IO[
            AwsError,
            zio.aws.snowball.model.ListClusterJobsResponse.ReadOnly
          ] = proxy(ListClusterJobsPaginated, request)
        }
      }
    }
    .toLayer
}
