package zio.aws.snowball.model
import zio.aws.snowball.model.primitives.AddressId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Address(
    addressId: Option[AddressId] = None,
    name: Option[String] = None,
    company: Option[String] = None,
    street1: Option[String] = None,
    street2: Option[String] = None,
    street3: Option[String] = None,
    city: Option[String] = None,
    stateOrProvince: Option[String] = None,
    prefectureOrDistrict: Option[String] = None,
    landmark: Option[String] = None,
    country: Option[String] = None,
    postalCode: Option[String] = None,
    phoneNumber: Option[String] = None,
    isRestricted: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.Address = {
    import Address.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.Address
      .builder()
      .optionallyWith(
        addressId.map(value => AddressId.unwrap(value): java.lang.String)
      )(_.addressId)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(company.map(value => value: java.lang.String))(_.company)
      .optionallyWith(street1.map(value => value: java.lang.String))(_.street1)
      .optionallyWith(street2.map(value => value: java.lang.String))(_.street2)
      .optionallyWith(street3.map(value => value: java.lang.String))(_.street3)
      .optionallyWith(city.map(value => value: java.lang.String))(_.city)
      .optionallyWith(stateOrProvince.map(value => value: java.lang.String))(
        _.stateOrProvince
      )
      .optionallyWith(
        prefectureOrDistrict.map(value => value: java.lang.String)
      )(_.prefectureOrDistrict)
      .optionallyWith(landmark.map(value => value: java.lang.String))(
        _.landmark
      )
      .optionallyWith(country.map(value => value: java.lang.String))(_.country)
      .optionallyWith(postalCode.map(value => value: java.lang.String))(
        _.postalCode
      )
      .optionallyWith(phoneNumber.map(value => value: java.lang.String))(
        _.phoneNumber
      )
      .optionallyWith(isRestricted.map(value => value: java.lang.Boolean))(
        _.isRestricted
      )
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.Address.ReadOnly =
    zio.aws.snowball.model.Address.wrap(buildAwsValue())
}
object Address {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.snowball.model.Address] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.Address =
      zio.aws.snowball.model.Address(
        addressId.map(value => value),
        name.map(value => value),
        company.map(value => value),
        street1.map(value => value),
        street2.map(value => value),
        street3.map(value => value),
        city.map(value => value),
        stateOrProvince.map(value => value),
        prefectureOrDistrict.map(value => value),
        landmark.map(value => value),
        country.map(value => value),
        postalCode.map(value => value),
        phoneNumber.map(value => value),
        isRestricted.map(value => value)
      )
    def addressId: Option[AddressId]
    def name: Option[String]
    def company: Option[String]
    def street1: Option[String]
    def street2: Option[String]
    def street3: Option[String]
    def city: Option[String]
    def stateOrProvince: Option[String]
    def prefectureOrDistrict: Option[String]
    def landmark: Option[String]
    def country: Option[String]
    def postalCode: Option[String]
    def phoneNumber: Option[String]
    def isRestricted: Option[Boolean]
    def getAddressId: ZIO[Any, AwsError, AddressId] =
      AwsError.unwrapOptionField("addressId", addressId)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getCompany: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("company", company)
    def getStreet1: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("street1", street1)
    def getStreet2: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("street2", street2)
    def getStreet3: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("street3", street3)
    def getCity: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("city", city)
    def getStateOrProvince: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stateOrProvince", stateOrProvince)
    def getPrefectureOrDistrict: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("prefectureOrDistrict", prefectureOrDistrict)
    def getLandmark: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("landmark", landmark)
    def getCountry: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("country", country)
    def getPostalCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("postalCode", postalCode)
    def getPhoneNumber: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("phoneNumber", phoneNumber)
    def getIsRestricted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isRestricted", isRestricted)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.Address
  ) extends zio.aws.snowball.model.Address.ReadOnly {
    override val addressId: Option[AddressId] = scala
      .Option(impl.addressId())
      .map(value => zio.aws.snowball.model.primitives.AddressId(value))
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val company: Option[String] =
      scala.Option(impl.company()).map(value => value: String)
    override val street1: Option[String] =
      scala.Option(impl.street1()).map(value => value: String)
    override val street2: Option[String] =
      scala.Option(impl.street2()).map(value => value: String)
    override val street3: Option[String] =
      scala.Option(impl.street3()).map(value => value: String)
    override val city: Option[String] =
      scala.Option(impl.city()).map(value => value: String)
    override val stateOrProvince: Option[String] =
      scala.Option(impl.stateOrProvince()).map(value => value: String)
    override val prefectureOrDistrict: Option[String] =
      scala.Option(impl.prefectureOrDistrict()).map(value => value: String)
    override val landmark: Option[String] =
      scala.Option(impl.landmark()).map(value => value: String)
    override val country: Option[String] =
      scala.Option(impl.country()).map(value => value: String)
    override val postalCode: Option[String] =
      scala.Option(impl.postalCode()).map(value => value: String)
    override val phoneNumber: Option[String] =
      scala.Option(impl.phoneNumber()).map(value => value: String)
    override val isRestricted: Option[Boolean] =
      scala.Option(impl.isRestricted()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.Address
  ): zio.aws.snowball.model.Address.ReadOnly = new Wrapper(impl)
}
