package zio.aws.snowball.model
import zio.aws.snowball.model.primitives.ClusterId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CancelClusterRequest(clusterId: ClusterId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.CancelClusterRequest = {
    import CancelClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.CancelClusterRequest
      .builder()
      .clusterId(ClusterId.unwrap(clusterId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.CancelClusterRequest.ReadOnly =
    zio.aws.snowball.model.CancelClusterRequest.wrap(buildAwsValue())
}
object CancelClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.CancelClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.CancelClusterRequest =
      zio.aws.snowball.model.CancelClusterRequest(clusterId)
    def clusterId: ClusterId
    def getClusterId: ZIO[Any, Nothing, ClusterId] = ZIO.succeed(clusterId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.CancelClusterRequest
  ) extends zio.aws.snowball.model.CancelClusterRequest.ReadOnly {
    override val clusterId: ClusterId =
      zio.aws.snowball.model.primitives.ClusterId(impl.clusterId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.CancelClusterRequest
  ): zio.aws.snowball.model.CancelClusterRequest.ReadOnly = new Wrapper(impl)
}
