package zio.aws.snowball.model
import zio.aws.snowball.model.primitives.JobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CancelJobRequest(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.CancelJobRequest = {
    import CancelJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.CancelJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.CancelJobRequest.ReadOnly =
    zio.aws.snowball.model.CancelJobRequest.wrap(buildAwsValue())
}
object CancelJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.CancelJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.CancelJobRequest =
      zio.aws.snowball.model.CancelJobRequest(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.CancelJobRequest
  ) extends zio.aws.snowball.model.CancelJobRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.snowball.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.CancelJobRequest
  ): zio.aws.snowball.model.CancelJobRequest.ReadOnly = new Wrapper(impl)
}
