package zio.aws.snowball.model
import zio.aws.snowball.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ClusterListEntry(
    clusterId: Option[String] = None,
    clusterState: Option[zio.aws.snowball.model.ClusterState] = None,
    creationDate: Option[Timestamp] = None,
    description: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.ClusterListEntry = {
    import ClusterListEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.ClusterListEntry
      .builder()
      .optionallyWith(clusterId.map(value => value: java.lang.String))(
        _.clusterId
      )
      .optionallyWith(clusterState.map(value => value.unwrap))(_.clusterState)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.ClusterListEntry.ReadOnly =
    zio.aws.snowball.model.ClusterListEntry.wrap(buildAwsValue())
}
object ClusterListEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.ClusterListEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.ClusterListEntry =
      zio.aws.snowball.model.ClusterListEntry(
        clusterId.map(value => value),
        clusterState.map(value => value),
        creationDate.map(value => value),
        description.map(value => value)
      )
    def clusterId: Option[String]
    def clusterState: Option[zio.aws.snowball.model.ClusterState]
    def creationDate: Option[Timestamp]
    def description: Option[String]
    def getClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterId", clusterId)
    def getClusterState
        : ZIO[Any, AwsError, zio.aws.snowball.model.ClusterState] =
      AwsError.unwrapOptionField("clusterState", clusterState)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.ClusterListEntry
  ) extends zio.aws.snowball.model.ClusterListEntry.ReadOnly {
    override val clusterId: Option[String] =
      scala.Option(impl.clusterId()).map(value => value: String)
    override val clusterState: Option[zio.aws.snowball.model.ClusterState] =
      scala
        .Option(impl.clusterState())
        .map(value => zio.aws.snowball.model.ClusterState.wrap(value))
    override val creationDate: Option[Timestamp] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.snowball.model.primitives.Timestamp(value))
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.ClusterListEntry
  ): zio.aws.snowball.model.ClusterListEntry.ReadOnly = new Wrapper(impl)
}
