package zio.aws.snowball.model
import zio.aws.snowball.model.primitives.{
  AddressId,
  Timestamp,
  RoleARN,
  KmsKeyARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ClusterMetadata(
    clusterId: Option[String] = None,
    description: Option[String] = None,
    kmsKeyARN: Option[KmsKeyARN] = None,
    roleARN: Option[RoleARN] = None,
    clusterState: Option[zio.aws.snowball.model.ClusterState] = None,
    jobType: Option[zio.aws.snowball.model.JobType] = None,
    snowballType: Option[zio.aws.snowball.model.SnowballType] = None,
    creationDate: Option[Timestamp] = None,
    resources: Option[zio.aws.snowball.model.JobResource] = None,
    addressId: Option[AddressId] = None,
    shippingOption: Option[zio.aws.snowball.model.ShippingOption] = None,
    notification: Option[zio.aws.snowball.model.Notification] = None,
    forwardingAddressId: Option[AddressId] = None,
    taxDocuments: Option[zio.aws.snowball.model.TaxDocuments] = None,
    onDeviceServiceConfiguration: Option[
      zio.aws.snowball.model.OnDeviceServiceConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.ClusterMetadata = {
    import ClusterMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.ClusterMetadata
      .builder()
      .optionallyWith(clusterId.map(value => value: java.lang.String))(
        _.clusterId
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        kmsKeyARN.map(value => KmsKeyARN.unwrap(value): java.lang.String)
      )(_.kmsKeyARN)
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .optionallyWith(clusterState.map(value => value.unwrap))(_.clusterState)
      .optionallyWith(jobType.map(value => value.unwrap))(_.jobType)
      .optionallyWith(snowballType.map(value => value.unwrap))(_.snowballType)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(resources.map(value => value.buildAwsValue()))(
        _.resources
      )
      .optionallyWith(
        addressId.map(value => AddressId.unwrap(value): java.lang.String)
      )(_.addressId)
      .optionallyWith(shippingOption.map(value => value.unwrap))(
        _.shippingOption
      )
      .optionallyWith(notification.map(value => value.buildAwsValue()))(
        _.notification
      )
      .optionallyWith(
        forwardingAddressId.map(value =>
          AddressId.unwrap(value): java.lang.String
        )
      )(_.forwardingAddressId)
      .optionallyWith(taxDocuments.map(value => value.buildAwsValue()))(
        _.taxDocuments
      )
      .optionallyWith(
        onDeviceServiceConfiguration.map(value => value.buildAwsValue())
      )(_.onDeviceServiceConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.ClusterMetadata.ReadOnly =
    zio.aws.snowball.model.ClusterMetadata.wrap(buildAwsValue())
}
object ClusterMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.ClusterMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.ClusterMetadata =
      zio.aws.snowball.model.ClusterMetadata(
        clusterId.map(value => value),
        description.map(value => value),
        kmsKeyARN.map(value => value),
        roleARN.map(value => value),
        clusterState.map(value => value),
        jobType.map(value => value),
        snowballType.map(value => value),
        creationDate.map(value => value),
        resources.map(value => value.asEditable),
        addressId.map(value => value),
        shippingOption.map(value => value),
        notification.map(value => value.asEditable),
        forwardingAddressId.map(value => value),
        taxDocuments.map(value => value.asEditable),
        onDeviceServiceConfiguration.map(value => value.asEditable)
      )
    def clusterId: Option[String]
    def description: Option[String]
    def kmsKeyARN: Option[KmsKeyARN]
    def roleARN: Option[RoleARN]
    def clusterState: Option[zio.aws.snowball.model.ClusterState]
    def jobType: Option[zio.aws.snowball.model.JobType]
    def snowballType: Option[zio.aws.snowball.model.SnowballType]
    def creationDate: Option[Timestamp]
    def resources: Option[zio.aws.snowball.model.JobResource.ReadOnly]
    def addressId: Option[AddressId]
    def shippingOption: Option[zio.aws.snowball.model.ShippingOption]
    def notification: Option[zio.aws.snowball.model.Notification.ReadOnly]
    def forwardingAddressId: Option[AddressId]
    def taxDocuments: Option[zio.aws.snowball.model.TaxDocuments.ReadOnly]
    def onDeviceServiceConfiguration
        : Option[zio.aws.snowball.model.OnDeviceServiceConfiguration.ReadOnly]
    def getClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterId", clusterId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getKmsKeyARN: ZIO[Any, AwsError, KmsKeyARN] =
      AwsError.unwrapOptionField("kmsKeyARN", kmsKeyARN)
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getClusterState
        : ZIO[Any, AwsError, zio.aws.snowball.model.ClusterState] =
      AwsError.unwrapOptionField("clusterState", clusterState)
    def getJobType: ZIO[Any, AwsError, zio.aws.snowball.model.JobType] =
      AwsError.unwrapOptionField("jobType", jobType)
    def getSnowballType
        : ZIO[Any, AwsError, zio.aws.snowball.model.SnowballType] =
      AwsError.unwrapOptionField("snowballType", snowballType)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getResources
        : ZIO[Any, AwsError, zio.aws.snowball.model.JobResource.ReadOnly] =
      AwsError.unwrapOptionField("resources", resources)
    def getAddressId: ZIO[Any, AwsError, AddressId] =
      AwsError.unwrapOptionField("addressId", addressId)
    def getShippingOption
        : ZIO[Any, AwsError, zio.aws.snowball.model.ShippingOption] =
      AwsError.unwrapOptionField("shippingOption", shippingOption)
    def getNotification
        : ZIO[Any, AwsError, zio.aws.snowball.model.Notification.ReadOnly] =
      AwsError.unwrapOptionField("notification", notification)
    def getForwardingAddressId: ZIO[Any, AwsError, AddressId] =
      AwsError.unwrapOptionField("forwardingAddressId", forwardingAddressId)
    def getTaxDocuments
        : ZIO[Any, AwsError, zio.aws.snowball.model.TaxDocuments.ReadOnly] =
      AwsError.unwrapOptionField("taxDocuments", taxDocuments)
    def getOnDeviceServiceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.snowball.model.OnDeviceServiceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "onDeviceServiceConfiguration",
      onDeviceServiceConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.ClusterMetadata
  ) extends zio.aws.snowball.model.ClusterMetadata.ReadOnly {
    override val clusterId: Option[String] =
      scala.Option(impl.clusterId()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val kmsKeyARN: Option[KmsKeyARN] = scala
      .Option(impl.kmsKeyARN())
      .map(value => zio.aws.snowball.model.primitives.KmsKeyARN(value))
    override val roleARN: Option[RoleARN] = scala
      .Option(impl.roleARN())
      .map(value => zio.aws.snowball.model.primitives.RoleARN(value))
    override val clusterState: Option[zio.aws.snowball.model.ClusterState] =
      scala
        .Option(impl.clusterState())
        .map(value => zio.aws.snowball.model.ClusterState.wrap(value))
    override val jobType: Option[zio.aws.snowball.model.JobType] = scala
      .Option(impl.jobType())
      .map(value => zio.aws.snowball.model.JobType.wrap(value))
    override val snowballType: Option[zio.aws.snowball.model.SnowballType] =
      scala
        .Option(impl.snowballType())
        .map(value => zio.aws.snowball.model.SnowballType.wrap(value))
    override val creationDate: Option[Timestamp] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.snowball.model.primitives.Timestamp(value))
    override val resources
        : Option[zio.aws.snowball.model.JobResource.ReadOnly] = scala
      .Option(impl.resources())
      .map(value => zio.aws.snowball.model.JobResource.wrap(value))
    override val addressId: Option[AddressId] = scala
      .Option(impl.addressId())
      .map(value => zio.aws.snowball.model.primitives.AddressId(value))
    override val shippingOption: Option[zio.aws.snowball.model.ShippingOption] =
      scala
        .Option(impl.shippingOption())
        .map(value => zio.aws.snowball.model.ShippingOption.wrap(value))
    override val notification
        : Option[zio.aws.snowball.model.Notification.ReadOnly] = scala
      .Option(impl.notification())
      .map(value => zio.aws.snowball.model.Notification.wrap(value))
    override val forwardingAddressId: Option[AddressId] = scala
      .Option(impl.forwardingAddressId())
      .map(value => zio.aws.snowball.model.primitives.AddressId(value))
    override val taxDocuments
        : Option[zio.aws.snowball.model.TaxDocuments.ReadOnly] = scala
      .Option(impl.taxDocuments())
      .map(value => zio.aws.snowball.model.TaxDocuments.wrap(value))
    override val onDeviceServiceConfiguration
        : Option[zio.aws.snowball.model.OnDeviceServiceConfiguration.ReadOnly] =
      scala
        .Option(impl.onDeviceServiceConfiguration())
        .map(value =>
          zio.aws.snowball.model.OnDeviceServiceConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.ClusterMetadata
  ): zio.aws.snowball.model.ClusterMetadata.ReadOnly = new Wrapper(impl)
}
