package zio.aws.snowball.model
import scala.jdk.CollectionConverters.*
sealed trait ClusterState {
  def unwrap: software.amazon.awssdk.services.snowball.model.ClusterState
}
object ClusterState {
  def wrap(
      value: software.amazon.awssdk.services.snowball.model.ClusterState
  ): zio.aws.snowball.model.ClusterState = value match {
    case software.amazon.awssdk.services.snowball.model.ClusterState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.snowball.model.ClusterState.AWAITING_QUORUM =>
      val r = AwaitingQuorum
      r
    case software.amazon.awssdk.services.snowball.model.ClusterState.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.snowball.model.ClusterState.IN_USE =>
      val r = InUse
      r
    case software.amazon.awssdk.services.snowball.model.ClusterState.COMPLETE =>
      val r = Complete
      r
    case software.amazon.awssdk.services.snowball.model.ClusterState.CANCELLED =>
      val r = Cancelled
      r
  }
  case object unknownToSdkVersion extends zio.aws.snowball.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.ClusterState =
      software.amazon.awssdk.services.snowball.model.ClusterState.UNKNOWN_TO_SDK_VERSION
  }
  case object AwaitingQuorum extends zio.aws.snowball.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.ClusterState =
      software.amazon.awssdk.services.snowball.model.ClusterState.AWAITING_QUORUM
  }
  case object Pending extends zio.aws.snowball.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.ClusterState =
      software.amazon.awssdk.services.snowball.model.ClusterState.PENDING
  }
  case object InUse extends zio.aws.snowball.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.ClusterState =
      software.amazon.awssdk.services.snowball.model.ClusterState.IN_USE
  }
  case object Complete extends zio.aws.snowball.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.ClusterState =
      software.amazon.awssdk.services.snowball.model.ClusterState.COMPLETE
  }
  case object Cancelled extends zio.aws.snowball.model.ClusterState {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.ClusterState =
      software.amazon.awssdk.services.snowball.model.ClusterState.CANCELLED
  }
}
