package zio.aws.snowball.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CompatibleImage(
    amiId: Option[String] = None,
    name: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.CompatibleImage = {
    import CompatibleImage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.CompatibleImage
      .builder()
      .optionallyWith(amiId.map(value => value: java.lang.String))(_.amiId)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.CompatibleImage.ReadOnly =
    zio.aws.snowball.model.CompatibleImage.wrap(buildAwsValue())
}
object CompatibleImage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.CompatibleImage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.CompatibleImage =
      zio.aws.snowball.model
        .CompatibleImage(amiId.map(value => value), name.map(value => value))
    def amiId: Option[String]
    def name: Option[String]
    def getAmiId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("amiId", amiId)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.CompatibleImage
  ) extends zio.aws.snowball.model.CompatibleImage.ReadOnly {
    override val amiId: Option[String] =
      scala.Option(impl.amiId()).map(value => value: String)
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.CompatibleImage
  ): zio.aws.snowball.model.CompatibleImage.ReadOnly = new Wrapper(impl)
}
