package zio.aws.snowball.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateAddressRequest(address: zio.aws.snowball.model.Address) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.CreateAddressRequest = {
    import CreateAddressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.CreateAddressRequest
      .builder()
      .address(address.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.CreateAddressRequest.ReadOnly =
    zio.aws.snowball.model.CreateAddressRequest.wrap(buildAwsValue())
}
object CreateAddressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.CreateAddressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.CreateAddressRequest =
      zio.aws.snowball.model.CreateAddressRequest(address.asEditable)
    def address: zio.aws.snowball.model.Address.ReadOnly
    def getAddress: ZIO[Any, Nothing, zio.aws.snowball.model.Address.ReadOnly] =
      ZIO.succeed(address)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.CreateAddressRequest
  ) extends zio.aws.snowball.model.CreateAddressRequest.ReadOnly {
    override val address: zio.aws.snowball.model.Address.ReadOnly =
      zio.aws.snowball.model.Address.wrap(impl.address())
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.CreateAddressRequest
  ): zio.aws.snowball.model.CreateAddressRequest.ReadOnly = new Wrapper(impl)
}
