package zio.aws.snowball.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateAddressResponse(addressId: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.CreateAddressResponse = {
    import CreateAddressResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.CreateAddressResponse
      .builder()
      .optionallyWith(addressId.map(value => value: java.lang.String))(
        _.addressId
      )
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.CreateAddressResponse.ReadOnly =
    zio.aws.snowball.model.CreateAddressResponse.wrap(buildAwsValue())
}
object CreateAddressResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.CreateAddressResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.CreateAddressResponse =
      zio.aws.snowball.model
        .CreateAddressResponse(addressId.map(value => value))
    def addressId: Option[String]
    def getAddressId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("addressId", addressId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.CreateAddressResponse
  ) extends zio.aws.snowball.model.CreateAddressResponse.ReadOnly {
    override val addressId: Option[String] =
      scala.Option(impl.addressId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.CreateAddressResponse
  ): zio.aws.snowball.model.CreateAddressResponse.ReadOnly = new Wrapper(impl)
}
