package zio.aws.snowball.model
import zio.aws.snowball.model.primitives.{RoleARN, KmsKeyARN, AddressId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateClusterRequest(
    jobType: zio.aws.snowball.model.JobType,
    resources: zio.aws.snowball.model.JobResource,
    onDeviceServiceConfiguration: Option[
      zio.aws.snowball.model.OnDeviceServiceConfiguration
    ] = None,
    description: Option[String] = None,
    addressId: AddressId,
    kmsKeyARN: Option[KmsKeyARN] = None,
    roleARN: RoleARN,
    snowballType: zio.aws.snowball.model.SnowballType,
    shippingOption: zio.aws.snowball.model.ShippingOption,
    notification: Option[zio.aws.snowball.model.Notification] = None,
    forwardingAddressId: Option[AddressId] = None,
    taxDocuments: Option[zio.aws.snowball.model.TaxDocuments] = None,
    remoteManagement: Option[zio.aws.snowball.model.RemoteManagement] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.CreateClusterRequest = {
    import CreateClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.CreateClusterRequest
      .builder()
      .jobType(jobType.unwrap)
      .resources(resources.buildAwsValue())
      .optionallyWith(
        onDeviceServiceConfiguration.map(value => value.buildAwsValue())
      )(_.onDeviceServiceConfiguration)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .addressId(AddressId.unwrap(addressId): java.lang.String)
      .optionallyWith(
        kmsKeyARN.map(value => KmsKeyARN.unwrap(value): java.lang.String)
      )(_.kmsKeyARN)
      .roleARN(RoleARN.unwrap(roleARN): java.lang.String)
      .snowballType(snowballType.unwrap)
      .shippingOption(shippingOption.unwrap)
      .optionallyWith(notification.map(value => value.buildAwsValue()))(
        _.notification
      )
      .optionallyWith(
        forwardingAddressId.map(value =>
          AddressId.unwrap(value): java.lang.String
        )
      )(_.forwardingAddressId)
      .optionallyWith(taxDocuments.map(value => value.buildAwsValue()))(
        _.taxDocuments
      )
      .optionallyWith(remoteManagement.map(value => value.unwrap))(
        _.remoteManagement
      )
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.CreateClusterRequest.ReadOnly =
    zio.aws.snowball.model.CreateClusterRequest.wrap(buildAwsValue())
}
object CreateClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.CreateClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.CreateClusterRequest =
      zio.aws.snowball.model.CreateClusterRequest(
        jobType,
        resources.asEditable,
        onDeviceServiceConfiguration.map(value => value.asEditable),
        description.map(value => value),
        addressId,
        kmsKeyARN.map(value => value),
        roleARN,
        snowballType,
        shippingOption,
        notification.map(value => value.asEditable),
        forwardingAddressId.map(value => value),
        taxDocuments.map(value => value.asEditable),
        remoteManagement.map(value => value)
      )
    def jobType: zio.aws.snowball.model.JobType
    def resources: zio.aws.snowball.model.JobResource.ReadOnly
    def onDeviceServiceConfiguration
        : Option[zio.aws.snowball.model.OnDeviceServiceConfiguration.ReadOnly]
    def description: Option[String]
    def addressId: AddressId
    def kmsKeyARN: Option[KmsKeyARN]
    def roleARN: RoleARN
    def snowballType: zio.aws.snowball.model.SnowballType
    def shippingOption: zio.aws.snowball.model.ShippingOption
    def notification: Option[zio.aws.snowball.model.Notification.ReadOnly]
    def forwardingAddressId: Option[AddressId]
    def taxDocuments: Option[zio.aws.snowball.model.TaxDocuments.ReadOnly]
    def remoteManagement: Option[zio.aws.snowball.model.RemoteManagement]
    def getJobType: ZIO[Any, Nothing, zio.aws.snowball.model.JobType] =
      ZIO.succeed(jobType)
    def getResources
        : ZIO[Any, Nothing, zio.aws.snowball.model.JobResource.ReadOnly] =
      ZIO.succeed(resources)
    def getOnDeviceServiceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.snowball.model.OnDeviceServiceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "onDeviceServiceConfiguration",
      onDeviceServiceConfiguration
    )
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getAddressId: ZIO[Any, Nothing, AddressId] = ZIO.succeed(addressId)
    def getKmsKeyARN: ZIO[Any, AwsError, KmsKeyARN] =
      AwsError.unwrapOptionField("kmsKeyARN", kmsKeyARN)
    def getRoleARN: ZIO[Any, Nothing, RoleARN] = ZIO.succeed(roleARN)
    def getSnowballType
        : ZIO[Any, Nothing, zio.aws.snowball.model.SnowballType] =
      ZIO.succeed(snowballType)
    def getShippingOption
        : ZIO[Any, Nothing, zio.aws.snowball.model.ShippingOption] =
      ZIO.succeed(shippingOption)
    def getNotification
        : ZIO[Any, AwsError, zio.aws.snowball.model.Notification.ReadOnly] =
      AwsError.unwrapOptionField("notification", notification)
    def getForwardingAddressId: ZIO[Any, AwsError, AddressId] =
      AwsError.unwrapOptionField("forwardingAddressId", forwardingAddressId)
    def getTaxDocuments
        : ZIO[Any, AwsError, zio.aws.snowball.model.TaxDocuments.ReadOnly] =
      AwsError.unwrapOptionField("taxDocuments", taxDocuments)
    def getRemoteManagement
        : ZIO[Any, AwsError, zio.aws.snowball.model.RemoteManagement] =
      AwsError.unwrapOptionField("remoteManagement", remoteManagement)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.CreateClusterRequest
  ) extends zio.aws.snowball.model.CreateClusterRequest.ReadOnly {
    override val jobType: zio.aws.snowball.model.JobType =
      zio.aws.snowball.model.JobType.wrap(impl.jobType())
    override val resources: zio.aws.snowball.model.JobResource.ReadOnly =
      zio.aws.snowball.model.JobResource.wrap(impl.resources())
    override val onDeviceServiceConfiguration
        : Option[zio.aws.snowball.model.OnDeviceServiceConfiguration.ReadOnly] =
      scala
        .Option(impl.onDeviceServiceConfiguration())
        .map(value =>
          zio.aws.snowball.model.OnDeviceServiceConfiguration.wrap(value)
        )
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val addressId: AddressId =
      zio.aws.snowball.model.primitives.AddressId(impl.addressId())
    override val kmsKeyARN: Option[KmsKeyARN] = scala
      .Option(impl.kmsKeyARN())
      .map(value => zio.aws.snowball.model.primitives.KmsKeyARN(value))
    override val roleARN: RoleARN =
      zio.aws.snowball.model.primitives.RoleARN(impl.roleARN())
    override val snowballType: zio.aws.snowball.model.SnowballType =
      zio.aws.snowball.model.SnowballType.wrap(impl.snowballType())
    override val shippingOption: zio.aws.snowball.model.ShippingOption =
      zio.aws.snowball.model.ShippingOption.wrap(impl.shippingOption())
    override val notification
        : Option[zio.aws.snowball.model.Notification.ReadOnly] = scala
      .Option(impl.notification())
      .map(value => zio.aws.snowball.model.Notification.wrap(value))
    override val forwardingAddressId: Option[AddressId] = scala
      .Option(impl.forwardingAddressId())
      .map(value => zio.aws.snowball.model.primitives.AddressId(value))
    override val taxDocuments
        : Option[zio.aws.snowball.model.TaxDocuments.ReadOnly] = scala
      .Option(impl.taxDocuments())
      .map(value => zio.aws.snowball.model.TaxDocuments.wrap(value))
    override val remoteManagement
        : Option[zio.aws.snowball.model.RemoteManagement] = scala
      .Option(impl.remoteManagement())
      .map(value => zio.aws.snowball.model.RemoteManagement.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.CreateClusterRequest
  ): zio.aws.snowball.model.CreateClusterRequest.ReadOnly = new Wrapper(impl)
}
