package zio.aws.snowball.model
import zio.aws.snowball.model.primitives.ClusterId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateClusterResponse(clusterId: Option[ClusterId] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.CreateClusterResponse = {
    import CreateClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.CreateClusterResponse
      .builder()
      .optionallyWith(
        clusterId.map(value => ClusterId.unwrap(value): java.lang.String)
      )(_.clusterId)
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.CreateClusterResponse.ReadOnly =
    zio.aws.snowball.model.CreateClusterResponse.wrap(buildAwsValue())
}
object CreateClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.CreateClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.CreateClusterResponse =
      zio.aws.snowball.model
        .CreateClusterResponse(clusterId.map(value => value))
    def clusterId: Option[ClusterId]
    def getClusterId: ZIO[Any, AwsError, ClusterId] =
      AwsError.unwrapOptionField("clusterId", clusterId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.CreateClusterResponse
  ) extends zio.aws.snowball.model.CreateClusterResponse.ReadOnly {
    override val clusterId: Option[ClusterId] = scala
      .Option(impl.clusterId())
      .map(value => zio.aws.snowball.model.primitives.ClusterId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.CreateClusterResponse
  ): zio.aws.snowball.model.CreateClusterResponse.ReadOnly = new Wrapper(impl)
}
