package zio.aws.snowball.model
import zio.aws.snowball.model.primitives.{
  KmsKeyARN,
  AddressId,
  RoleARN,
  LongTermPricingId,
  ClusterId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateJobRequest(
    jobType: Option[zio.aws.snowball.model.JobType] = None,
    resources: Option[zio.aws.snowball.model.JobResource] = None,
    onDeviceServiceConfiguration: Option[
      zio.aws.snowball.model.OnDeviceServiceConfiguration
    ] = None,
    description: Option[String] = None,
    addressId: Option[AddressId] = None,
    kmsKeyARN: Option[KmsKeyARN] = None,
    roleARN: Option[RoleARN] = None,
    snowballCapacityPreference: Option[
      zio.aws.snowball.model.SnowballCapacity
    ] = None,
    shippingOption: Option[zio.aws.snowball.model.ShippingOption] = None,
    notification: Option[zio.aws.snowball.model.Notification] = None,
    clusterId: Option[ClusterId] = None,
    snowballType: Option[zio.aws.snowball.model.SnowballType] = None,
    forwardingAddressId: Option[AddressId] = None,
    taxDocuments: Option[zio.aws.snowball.model.TaxDocuments] = None,
    deviceConfiguration: Option[zio.aws.snowball.model.DeviceConfiguration] =
      None,
    remoteManagement: Option[zio.aws.snowball.model.RemoteManagement] = None,
    longTermPricingId: Option[LongTermPricingId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.CreateJobRequest = {
    import CreateJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.CreateJobRequest
      .builder()
      .optionallyWith(jobType.map(value => value.unwrap))(_.jobType)
      .optionallyWith(resources.map(value => value.buildAwsValue()))(
        _.resources
      )
      .optionallyWith(
        onDeviceServiceConfiguration.map(value => value.buildAwsValue())
      )(_.onDeviceServiceConfiguration)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        addressId.map(value => AddressId.unwrap(value): java.lang.String)
      )(_.addressId)
      .optionallyWith(
        kmsKeyARN.map(value => KmsKeyARN.unwrap(value): java.lang.String)
      )(_.kmsKeyARN)
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .optionallyWith(snowballCapacityPreference.map(value => value.unwrap))(
        _.snowballCapacityPreference
      )
      .optionallyWith(shippingOption.map(value => value.unwrap))(
        _.shippingOption
      )
      .optionallyWith(notification.map(value => value.buildAwsValue()))(
        _.notification
      )
      .optionallyWith(
        clusterId.map(value => ClusterId.unwrap(value): java.lang.String)
      )(_.clusterId)
      .optionallyWith(snowballType.map(value => value.unwrap))(_.snowballType)
      .optionallyWith(
        forwardingAddressId.map(value =>
          AddressId.unwrap(value): java.lang.String
        )
      )(_.forwardingAddressId)
      .optionallyWith(taxDocuments.map(value => value.buildAwsValue()))(
        _.taxDocuments
      )
      .optionallyWith(deviceConfiguration.map(value => value.buildAwsValue()))(
        _.deviceConfiguration
      )
      .optionallyWith(remoteManagement.map(value => value.unwrap))(
        _.remoteManagement
      )
      .optionallyWith(
        longTermPricingId.map(value =>
          LongTermPricingId.unwrap(value): java.lang.String
        )
      )(_.longTermPricingId)
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.CreateJobRequest.ReadOnly =
    zio.aws.snowball.model.CreateJobRequest.wrap(buildAwsValue())
}
object CreateJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.CreateJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.CreateJobRequest =
      zio.aws.snowball.model.CreateJobRequest(
        jobType.map(value => value),
        resources.map(value => value.asEditable),
        onDeviceServiceConfiguration.map(value => value.asEditable),
        description.map(value => value),
        addressId.map(value => value),
        kmsKeyARN.map(value => value),
        roleARN.map(value => value),
        snowballCapacityPreference.map(value => value),
        shippingOption.map(value => value),
        notification.map(value => value.asEditable),
        clusterId.map(value => value),
        snowballType.map(value => value),
        forwardingAddressId.map(value => value),
        taxDocuments.map(value => value.asEditable),
        deviceConfiguration.map(value => value.asEditable),
        remoteManagement.map(value => value),
        longTermPricingId.map(value => value)
      )
    def jobType: Option[zio.aws.snowball.model.JobType]
    def resources: Option[zio.aws.snowball.model.JobResource.ReadOnly]
    def onDeviceServiceConfiguration
        : Option[zio.aws.snowball.model.OnDeviceServiceConfiguration.ReadOnly]
    def description: Option[String]
    def addressId: Option[AddressId]
    def kmsKeyARN: Option[KmsKeyARN]
    def roleARN: Option[RoleARN]
    def snowballCapacityPreference
        : Option[zio.aws.snowball.model.SnowballCapacity]
    def shippingOption: Option[zio.aws.snowball.model.ShippingOption]
    def notification: Option[zio.aws.snowball.model.Notification.ReadOnly]
    def clusterId: Option[ClusterId]
    def snowballType: Option[zio.aws.snowball.model.SnowballType]
    def forwardingAddressId: Option[AddressId]
    def taxDocuments: Option[zio.aws.snowball.model.TaxDocuments.ReadOnly]
    def deviceConfiguration
        : Option[zio.aws.snowball.model.DeviceConfiguration.ReadOnly]
    def remoteManagement: Option[zio.aws.snowball.model.RemoteManagement]
    def longTermPricingId: Option[LongTermPricingId]
    def getJobType: ZIO[Any, AwsError, zio.aws.snowball.model.JobType] =
      AwsError.unwrapOptionField("jobType", jobType)
    def getResources
        : ZIO[Any, AwsError, zio.aws.snowball.model.JobResource.ReadOnly] =
      AwsError.unwrapOptionField("resources", resources)
    def getOnDeviceServiceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.snowball.model.OnDeviceServiceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "onDeviceServiceConfiguration",
      onDeviceServiceConfiguration
    )
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getAddressId: ZIO[Any, AwsError, AddressId] =
      AwsError.unwrapOptionField("addressId", addressId)
    def getKmsKeyARN: ZIO[Any, AwsError, KmsKeyARN] =
      AwsError.unwrapOptionField("kmsKeyARN", kmsKeyARN)
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getSnowballCapacityPreference
        : ZIO[Any, AwsError, zio.aws.snowball.model.SnowballCapacity] =
      AwsError.unwrapOptionField(
        "snowballCapacityPreference",
        snowballCapacityPreference
      )
    def getShippingOption
        : ZIO[Any, AwsError, zio.aws.snowball.model.ShippingOption] =
      AwsError.unwrapOptionField("shippingOption", shippingOption)
    def getNotification
        : ZIO[Any, AwsError, zio.aws.snowball.model.Notification.ReadOnly] =
      AwsError.unwrapOptionField("notification", notification)
    def getClusterId: ZIO[Any, AwsError, ClusterId] =
      AwsError.unwrapOptionField("clusterId", clusterId)
    def getSnowballType
        : ZIO[Any, AwsError, zio.aws.snowball.model.SnowballType] =
      AwsError.unwrapOptionField("snowballType", snowballType)
    def getForwardingAddressId: ZIO[Any, AwsError, AddressId] =
      AwsError.unwrapOptionField("forwardingAddressId", forwardingAddressId)
    def getTaxDocuments
        : ZIO[Any, AwsError, zio.aws.snowball.model.TaxDocuments.ReadOnly] =
      AwsError.unwrapOptionField("taxDocuments", taxDocuments)
    def getDeviceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.snowball.model.DeviceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("deviceConfiguration", deviceConfiguration)
    def getRemoteManagement
        : ZIO[Any, AwsError, zio.aws.snowball.model.RemoteManagement] =
      AwsError.unwrapOptionField("remoteManagement", remoteManagement)
    def getLongTermPricingId: ZIO[Any, AwsError, LongTermPricingId] =
      AwsError.unwrapOptionField("longTermPricingId", longTermPricingId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.CreateJobRequest
  ) extends zio.aws.snowball.model.CreateJobRequest.ReadOnly {
    override val jobType: Option[zio.aws.snowball.model.JobType] = scala
      .Option(impl.jobType())
      .map(value => zio.aws.snowball.model.JobType.wrap(value))
    override val resources
        : Option[zio.aws.snowball.model.JobResource.ReadOnly] = scala
      .Option(impl.resources())
      .map(value => zio.aws.snowball.model.JobResource.wrap(value))
    override val onDeviceServiceConfiguration
        : Option[zio.aws.snowball.model.OnDeviceServiceConfiguration.ReadOnly] =
      scala
        .Option(impl.onDeviceServiceConfiguration())
        .map(value =>
          zio.aws.snowball.model.OnDeviceServiceConfiguration.wrap(value)
        )
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val addressId: Option[AddressId] = scala
      .Option(impl.addressId())
      .map(value => zio.aws.snowball.model.primitives.AddressId(value))
    override val kmsKeyARN: Option[KmsKeyARN] = scala
      .Option(impl.kmsKeyARN())
      .map(value => zio.aws.snowball.model.primitives.KmsKeyARN(value))
    override val roleARN: Option[RoleARN] = scala
      .Option(impl.roleARN())
      .map(value => zio.aws.snowball.model.primitives.RoleARN(value))
    override val snowballCapacityPreference
        : Option[zio.aws.snowball.model.SnowballCapacity] = scala
      .Option(impl.snowballCapacityPreference())
      .map(value => zio.aws.snowball.model.SnowballCapacity.wrap(value))
    override val shippingOption: Option[zio.aws.snowball.model.ShippingOption] =
      scala
        .Option(impl.shippingOption())
        .map(value => zio.aws.snowball.model.ShippingOption.wrap(value))
    override val notification
        : Option[zio.aws.snowball.model.Notification.ReadOnly] = scala
      .Option(impl.notification())
      .map(value => zio.aws.snowball.model.Notification.wrap(value))
    override val clusterId: Option[ClusterId] = scala
      .Option(impl.clusterId())
      .map(value => zio.aws.snowball.model.primitives.ClusterId(value))
    override val snowballType: Option[zio.aws.snowball.model.SnowballType] =
      scala
        .Option(impl.snowballType())
        .map(value => zio.aws.snowball.model.SnowballType.wrap(value))
    override val forwardingAddressId: Option[AddressId] = scala
      .Option(impl.forwardingAddressId())
      .map(value => zio.aws.snowball.model.primitives.AddressId(value))
    override val taxDocuments
        : Option[zio.aws.snowball.model.TaxDocuments.ReadOnly] = scala
      .Option(impl.taxDocuments())
      .map(value => zio.aws.snowball.model.TaxDocuments.wrap(value))
    override val deviceConfiguration
        : Option[zio.aws.snowball.model.DeviceConfiguration.ReadOnly] = scala
      .Option(impl.deviceConfiguration())
      .map(value => zio.aws.snowball.model.DeviceConfiguration.wrap(value))
    override val remoteManagement
        : Option[zio.aws.snowball.model.RemoteManagement] = scala
      .Option(impl.remoteManagement())
      .map(value => zio.aws.snowball.model.RemoteManagement.wrap(value))
    override val longTermPricingId: Option[LongTermPricingId] = scala
      .Option(impl.longTermPricingId())
      .map(value => zio.aws.snowball.model.primitives.LongTermPricingId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.CreateJobRequest
  ): zio.aws.snowball.model.CreateJobRequest.ReadOnly = new Wrapper(impl)
}
