package zio.aws.snowball.model
import zio.aws.snowball.model.primitives.JavaBoolean
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateLongTermPricingRequest(
    longTermPricingType: zio.aws.snowball.model.LongTermPricingType,
    isLongTermPricingAutoRenew: Option[JavaBoolean] = None,
    snowballType: Option[zio.aws.snowball.model.SnowballType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.CreateLongTermPricingRequest = {
    import CreateLongTermPricingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.CreateLongTermPricingRequest
      .builder()
      .longTermPricingType(longTermPricingType.unwrap)
      .optionallyWith(
        isLongTermPricingAutoRenew.map(value =>
          JavaBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.isLongTermPricingAutoRenew)
      .optionallyWith(snowballType.map(value => value.unwrap))(_.snowballType)
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.CreateLongTermPricingRequest.ReadOnly =
    zio.aws.snowball.model.CreateLongTermPricingRequest.wrap(buildAwsValue())
}
object CreateLongTermPricingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.CreateLongTermPricingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.CreateLongTermPricingRequest =
      zio.aws.snowball.model.CreateLongTermPricingRequest(
        longTermPricingType,
        isLongTermPricingAutoRenew.map(value => value),
        snowballType.map(value => value)
      )
    def longTermPricingType: zio.aws.snowball.model.LongTermPricingType
    def isLongTermPricingAutoRenew: Option[JavaBoolean]
    def snowballType: Option[zio.aws.snowball.model.SnowballType]
    def getLongTermPricingType
        : ZIO[Any, Nothing, zio.aws.snowball.model.LongTermPricingType] =
      ZIO.succeed(longTermPricingType)
    def getIsLongTermPricingAutoRenew: ZIO[Any, AwsError, JavaBoolean] =
      AwsError.unwrapOptionField(
        "isLongTermPricingAutoRenew",
        isLongTermPricingAutoRenew
      )
    def getSnowballType
        : ZIO[Any, AwsError, zio.aws.snowball.model.SnowballType] =
      AwsError.unwrapOptionField("snowballType", snowballType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.CreateLongTermPricingRequest
  ) extends zio.aws.snowball.model.CreateLongTermPricingRequest.ReadOnly {
    override val longTermPricingType
        : zio.aws.snowball.model.LongTermPricingType =
      zio.aws.snowball.model.LongTermPricingType
        .wrap(impl.longTermPricingType())
    override val isLongTermPricingAutoRenew: Option[JavaBoolean] = scala
      .Option(impl.isLongTermPricingAutoRenew())
      .map(value => zio.aws.snowball.model.primitives.JavaBoolean(value))
    override val snowballType: Option[zio.aws.snowball.model.SnowballType] =
      scala
        .Option(impl.snowballType())
        .map(value => zio.aws.snowball.model.SnowballType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.CreateLongTermPricingRequest
  ): zio.aws.snowball.model.CreateLongTermPricingRequest.ReadOnly = new Wrapper(
    impl
  )
}
