package zio.aws.snowball.model
import zio.aws.snowball.model.primitives.LongTermPricingId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateLongTermPricingResponse(
    longTermPricingId: Option[LongTermPricingId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.CreateLongTermPricingResponse = {
    import CreateLongTermPricingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.CreateLongTermPricingResponse
      .builder()
      .optionallyWith(
        longTermPricingId.map(value =>
          LongTermPricingId.unwrap(value): java.lang.String
        )
      )(_.longTermPricingId)
      .build()
  }
  def asReadOnly
      : zio.aws.snowball.model.CreateLongTermPricingResponse.ReadOnly =
    zio.aws.snowball.model.CreateLongTermPricingResponse.wrap(buildAwsValue())
}
object CreateLongTermPricingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.CreateLongTermPricingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.CreateLongTermPricingResponse =
      zio.aws.snowball.model
        .CreateLongTermPricingResponse(longTermPricingId.map(value => value))
    def longTermPricingId: Option[LongTermPricingId]
    def getLongTermPricingId: ZIO[Any, AwsError, LongTermPricingId] =
      AwsError.unwrapOptionField("longTermPricingId", longTermPricingId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.CreateLongTermPricingResponse
  ) extends zio.aws.snowball.model.CreateLongTermPricingResponse.ReadOnly {
    override val longTermPricingId: Option[LongTermPricingId] = scala
      .Option(impl.longTermPricingId())
      .map(value => zio.aws.snowball.model.primitives.LongTermPricingId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.CreateLongTermPricingResponse
  ): zio.aws.snowball.model.CreateLongTermPricingResponse.ReadOnly =
    new Wrapper(impl)
}
