package zio.aws.snowball.model
import zio.aws.snowball.model.primitives.JobId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateReturnShippingLabelRequest(
    jobId: JobId,
    shippingOption: Option[zio.aws.snowball.model.ShippingOption] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.CreateReturnShippingLabelRequest = {
    import CreateReturnShippingLabelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.CreateReturnShippingLabelRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .optionallyWith(shippingOption.map(value => value.unwrap))(
        _.shippingOption
      )
      .build()
  }
  def asReadOnly
      : zio.aws.snowball.model.CreateReturnShippingLabelRequest.ReadOnly =
    zio.aws.snowball.model.CreateReturnShippingLabelRequest
      .wrap(buildAwsValue())
}
object CreateReturnShippingLabelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.CreateReturnShippingLabelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.CreateReturnShippingLabelRequest =
      zio.aws.snowball.model.CreateReturnShippingLabelRequest(
        jobId,
        shippingOption.map(value => value)
      )
    def jobId: JobId
    def shippingOption: Option[zio.aws.snowball.model.ShippingOption]
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getShippingOption
        : ZIO[Any, AwsError, zio.aws.snowball.model.ShippingOption] =
      AwsError.unwrapOptionField("shippingOption", shippingOption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.CreateReturnShippingLabelRequest
  ) extends zio.aws.snowball.model.CreateReturnShippingLabelRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.snowball.model.primitives.JobId(impl.jobId())
    override val shippingOption: Option[zio.aws.snowball.model.ShippingOption] =
      scala
        .Option(impl.shippingOption())
        .map(value => zio.aws.snowball.model.ShippingOption.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.CreateReturnShippingLabelRequest
  ): zio.aws.snowball.model.CreateReturnShippingLabelRequest.ReadOnly =
    new Wrapper(impl)
}
