package zio.aws.snowball.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateReturnShippingLabelResponse(
    status: Option[zio.aws.snowball.model.ShippingLabelStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.CreateReturnShippingLabelResponse = {
    import CreateReturnShippingLabelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.CreateReturnShippingLabelResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.snowball.model.CreateReturnShippingLabelResponse.ReadOnly =
    zio.aws.snowball.model.CreateReturnShippingLabelResponse
      .wrap(buildAwsValue())
}
object CreateReturnShippingLabelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.CreateReturnShippingLabelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.CreateReturnShippingLabelResponse =
      zio.aws.snowball.model
        .CreateReturnShippingLabelResponse(status.map(value => value))
    def status: Option[zio.aws.snowball.model.ShippingLabelStatus]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.snowball.model.ShippingLabelStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.CreateReturnShippingLabelResponse
  ) extends zio.aws.snowball.model.CreateReturnShippingLabelResponse.ReadOnly {
    override val status: Option[zio.aws.snowball.model.ShippingLabelStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.snowball.model.ShippingLabelStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.CreateReturnShippingLabelResponse
  ): zio.aws.snowball.model.CreateReturnShippingLabelResponse.ReadOnly =
    new Wrapper(impl)
}
