package zio.aws.snowball.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DataTransfer(
    bytesTransferred: Option[Long] = None,
    objectsTransferred: Option[Long] = None,
    totalBytes: Option[Long] = None,
    totalObjects: Option[Long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.DataTransfer = {
    import DataTransfer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.DataTransfer
      .builder()
      .optionallyWith(bytesTransferred.map(value => value: java.lang.Long))(
        _.bytesTransferred
      )
      .optionallyWith(objectsTransferred.map(value => value: java.lang.Long))(
        _.objectsTransferred
      )
      .optionallyWith(totalBytes.map(value => value: java.lang.Long))(
        _.totalBytes
      )
      .optionallyWith(totalObjects.map(value => value: java.lang.Long))(
        _.totalObjects
      )
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.DataTransfer.ReadOnly =
    zio.aws.snowball.model.DataTransfer.wrap(buildAwsValue())
}
object DataTransfer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.DataTransfer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.DataTransfer =
      zio.aws.snowball.model.DataTransfer(
        bytesTransferred.map(value => value),
        objectsTransferred.map(value => value),
        totalBytes.map(value => value),
        totalObjects.map(value => value)
      )
    def bytesTransferred: Option[Long]
    def objectsTransferred: Option[Long]
    def totalBytes: Option[Long]
    def totalObjects: Option[Long]
    def getBytesTransferred: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("bytesTransferred", bytesTransferred)
    def getObjectsTransferred: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("objectsTransferred", objectsTransferred)
    def getTotalBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("totalBytes", totalBytes)
    def getTotalObjects: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("totalObjects", totalObjects)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.DataTransfer
  ) extends zio.aws.snowball.model.DataTransfer.ReadOnly {
    override val bytesTransferred: Option[Long] =
      scala.Option(impl.bytesTransferred()).map(value => value: Long)
    override val objectsTransferred: Option[Long] =
      scala.Option(impl.objectsTransferred()).map(value => value: Long)
    override val totalBytes: Option[Long] =
      scala.Option(impl.totalBytes()).map(value => value: Long)
    override val totalObjects: Option[Long] =
      scala.Option(impl.totalObjects()).map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.DataTransfer
  ): zio.aws.snowball.model.DataTransfer.ReadOnly = new Wrapper(impl)
}
