package zio.aws.snowball.model
import zio.aws.snowball.model.primitives.AddressId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeAddressRequest(addressId: AddressId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.DescribeAddressRequest = {
    import DescribeAddressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.DescribeAddressRequest
      .builder()
      .addressId(AddressId.unwrap(addressId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.DescribeAddressRequest.ReadOnly =
    zio.aws.snowball.model.DescribeAddressRequest.wrap(buildAwsValue())
}
object DescribeAddressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.DescribeAddressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.DescribeAddressRequest =
      zio.aws.snowball.model.DescribeAddressRequest(addressId)
    def addressId: AddressId
    def getAddressId: ZIO[Any, Nothing, AddressId] = ZIO.succeed(addressId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.DescribeAddressRequest
  ) extends zio.aws.snowball.model.DescribeAddressRequest.ReadOnly {
    override val addressId: AddressId =
      zio.aws.snowball.model.primitives.AddressId(impl.addressId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.DescribeAddressRequest
  ): zio.aws.snowball.model.DescribeAddressRequest.ReadOnly = new Wrapper(impl)
}
