package zio.aws.snowball.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeAddressResponse(
    address: Option[zio.aws.snowball.model.Address] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.DescribeAddressResponse = {
    import DescribeAddressResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.DescribeAddressResponse
      .builder()
      .optionallyWith(address.map(value => value.buildAwsValue()))(_.address)
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.DescribeAddressResponse.ReadOnly =
    zio.aws.snowball.model.DescribeAddressResponse.wrap(buildAwsValue())
}
object DescribeAddressResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.DescribeAddressResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.DescribeAddressResponse =
      zio.aws.snowball.model
        .DescribeAddressResponse(address.map(value => value.asEditable))
    def address: Option[zio.aws.snowball.model.Address.ReadOnly]
    def getAddress
        : ZIO[Any, AwsError, zio.aws.snowball.model.Address.ReadOnly] =
      AwsError.unwrapOptionField("address", address)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.DescribeAddressResponse
  ) extends zio.aws.snowball.model.DescribeAddressResponse.ReadOnly {
    override val address: Option[zio.aws.snowball.model.Address.ReadOnly] =
      scala
        .Option(impl.address())
        .map(value => zio.aws.snowball.model.Address.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.DescribeAddressResponse
  ): zio.aws.snowball.model.DescribeAddressResponse.ReadOnly = new Wrapper(impl)
}
