package zio.aws.snowball.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeAddressesResponse(
    addresses: Option[Iterable[zio.aws.snowball.model.Address]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.DescribeAddressesResponse = {
    import DescribeAddressesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.DescribeAddressesResponse
      .builder()
      .optionallyWith(
        addresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addresses)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.DescribeAddressesResponse.ReadOnly =
    zio.aws.snowball.model.DescribeAddressesResponse.wrap(buildAwsValue())
}
object DescribeAddressesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.DescribeAddressesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.DescribeAddressesResponse =
      zio.aws.snowball.model.DescribeAddressesResponse(
        addresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def addresses: Option[List[zio.aws.snowball.model.Address.ReadOnly]]
    def nextToken: Option[String]
    def getAddresses
        : ZIO[Any, AwsError, List[zio.aws.snowball.model.Address.ReadOnly]] =
      AwsError.unwrapOptionField("addresses", addresses)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.DescribeAddressesResponse
  ) extends zio.aws.snowball.model.DescribeAddressesResponse.ReadOnly {
    override val addresses
        : Option[List[zio.aws.snowball.model.Address.ReadOnly]] = scala
      .Option(impl.addresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.snowball.model.Address.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.DescribeAddressesResponse
  ): zio.aws.snowball.model.DescribeAddressesResponse.ReadOnly = new Wrapper(
    impl
  )
}
