package zio.aws.snowball.model
import zio.aws.snowball.model.primitives.ClusterId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeClusterRequest(clusterId: ClusterId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.DescribeClusterRequest = {
    import DescribeClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.DescribeClusterRequest
      .builder()
      .clusterId(ClusterId.unwrap(clusterId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.DescribeClusterRequest.ReadOnly =
    zio.aws.snowball.model.DescribeClusterRequest.wrap(buildAwsValue())
}
object DescribeClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.DescribeClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.DescribeClusterRequest =
      zio.aws.snowball.model.DescribeClusterRequest(clusterId)
    def clusterId: ClusterId
    def getClusterId: ZIO[Any, Nothing, ClusterId] = ZIO.succeed(clusterId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.DescribeClusterRequest
  ) extends zio.aws.snowball.model.DescribeClusterRequest.ReadOnly {
    override val clusterId: ClusterId =
      zio.aws.snowball.model.primitives.ClusterId(impl.clusterId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.DescribeClusterRequest
  ): zio.aws.snowball.model.DescribeClusterRequest.ReadOnly = new Wrapper(impl)
}
