package zio.aws.snowball.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeClusterResponse(
    clusterMetadata: Option[zio.aws.snowball.model.ClusterMetadata] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.DescribeClusterResponse = {
    import DescribeClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.DescribeClusterResponse
      .builder()
      .optionallyWith(clusterMetadata.map(value => value.buildAwsValue()))(
        _.clusterMetadata
      )
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.DescribeClusterResponse.ReadOnly =
    zio.aws.snowball.model.DescribeClusterResponse.wrap(buildAwsValue())
}
object DescribeClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.DescribeClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.DescribeClusterResponse =
      zio.aws.snowball.model
        .DescribeClusterResponse(clusterMetadata.map(value => value.asEditable))
    def clusterMetadata: Option[zio.aws.snowball.model.ClusterMetadata.ReadOnly]
    def getClusterMetadata
        : ZIO[Any, AwsError, zio.aws.snowball.model.ClusterMetadata.ReadOnly] =
      AwsError.unwrapOptionField("clusterMetadata", clusterMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.DescribeClusterResponse
  ) extends zio.aws.snowball.model.DescribeClusterResponse.ReadOnly {
    override val clusterMetadata
        : Option[zio.aws.snowball.model.ClusterMetadata.ReadOnly] = scala
      .Option(impl.clusterMetadata())
      .map(value => zio.aws.snowball.model.ClusterMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.DescribeClusterResponse
  ): zio.aws.snowball.model.DescribeClusterResponse.ReadOnly = new Wrapper(impl)
}
