package zio.aws.snowball.model
import zio.aws.snowball.model.primitives.JobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeJobRequest(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.DescribeJobRequest = {
    import DescribeJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.DescribeJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.DescribeJobRequest.ReadOnly =
    zio.aws.snowball.model.DescribeJobRequest.wrap(buildAwsValue())
}
object DescribeJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.DescribeJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.DescribeJobRequest =
      zio.aws.snowball.model.DescribeJobRequest(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.DescribeJobRequest
  ) extends zio.aws.snowball.model.DescribeJobRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.snowball.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.DescribeJobRequest
  ): zio.aws.snowball.model.DescribeJobRequest.ReadOnly = new Wrapper(impl)
}
