package zio.aws.snowball.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeJobResponse(
    jobMetadata: Option[zio.aws.snowball.model.JobMetadata] = None,
    subJobMetadata: Option[Iterable[zio.aws.snowball.model.JobMetadata]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.DescribeJobResponse = {
    import DescribeJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.DescribeJobResponse
      .builder()
      .optionallyWith(jobMetadata.map(value => value.buildAwsValue()))(
        _.jobMetadata
      )
      .optionallyWith(
        subJobMetadata.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subJobMetadata)
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.DescribeJobResponse.ReadOnly =
    zio.aws.snowball.model.DescribeJobResponse.wrap(buildAwsValue())
}
object DescribeJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.DescribeJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.DescribeJobResponse =
      zio.aws.snowball.model.DescribeJobResponse(
        jobMetadata.map(value => value.asEditable),
        subJobMetadata.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def jobMetadata: Option[zio.aws.snowball.model.JobMetadata.ReadOnly]
    def subJobMetadata
        : Option[List[zio.aws.snowball.model.JobMetadata.ReadOnly]]
    def getJobMetadata
        : ZIO[Any, AwsError, zio.aws.snowball.model.JobMetadata.ReadOnly] =
      AwsError.unwrapOptionField("jobMetadata", jobMetadata)
    def getSubJobMetadata: ZIO[Any, AwsError, List[
      zio.aws.snowball.model.JobMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("subJobMetadata", subJobMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.DescribeJobResponse
  ) extends zio.aws.snowball.model.DescribeJobResponse.ReadOnly {
    override val jobMetadata
        : Option[zio.aws.snowball.model.JobMetadata.ReadOnly] = scala
      .Option(impl.jobMetadata())
      .map(value => zio.aws.snowball.model.JobMetadata.wrap(value))
    override val subJobMetadata
        : Option[List[zio.aws.snowball.model.JobMetadata.ReadOnly]] = scala
      .Option(impl.subJobMetadata())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.snowball.model.JobMetadata.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.DescribeJobResponse
  ): zio.aws.snowball.model.DescribeJobResponse.ReadOnly = new Wrapper(impl)
}
