package zio.aws.snowball.model
import zio.aws.snowball.model.primitives.JobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeReturnShippingLabelRequest(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.DescribeReturnShippingLabelRequest = {
    import DescribeReturnShippingLabelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.DescribeReturnShippingLabelRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.snowball.model.DescribeReturnShippingLabelRequest.ReadOnly =
    zio.aws.snowball.model.DescribeReturnShippingLabelRequest
      .wrap(buildAwsValue())
}
object DescribeReturnShippingLabelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.DescribeReturnShippingLabelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.DescribeReturnShippingLabelRequest =
      zio.aws.snowball.model.DescribeReturnShippingLabelRequest(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.DescribeReturnShippingLabelRequest
  ) extends zio.aws.snowball.model.DescribeReturnShippingLabelRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.snowball.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.DescribeReturnShippingLabelRequest
  ): zio.aws.snowball.model.DescribeReturnShippingLabelRequest.ReadOnly =
    new Wrapper(impl)
}
