package zio.aws.snowball.model
import zio.aws.snowball.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DescribeReturnShippingLabelResponse(
    status: Option[zio.aws.snowball.model.ShippingLabelStatus] = None,
    expirationDate: Option[Timestamp] = None,
    returnShippingLabelURI: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.DescribeReturnShippingLabelResponse = {
    import DescribeReturnShippingLabelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.DescribeReturnShippingLabelResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        expirationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.expirationDate)
      .optionallyWith(
        returnShippingLabelURI.map(value => value: java.lang.String)
      )(_.returnShippingLabelURI)
      .build()
  }
  def asReadOnly
      : zio.aws.snowball.model.DescribeReturnShippingLabelResponse.ReadOnly =
    zio.aws.snowball.model.DescribeReturnShippingLabelResponse
      .wrap(buildAwsValue())
}
object DescribeReturnShippingLabelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.DescribeReturnShippingLabelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.DescribeReturnShippingLabelResponse =
      zio.aws.snowball.model.DescribeReturnShippingLabelResponse(
        status.map(value => value),
        expirationDate.map(value => value),
        returnShippingLabelURI.map(value => value)
      )
    def status: Option[zio.aws.snowball.model.ShippingLabelStatus]
    def expirationDate: Option[Timestamp]
    def returnShippingLabelURI: Option[String]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.snowball.model.ShippingLabelStatus] =
      AwsError.unwrapOptionField("status", status)
    def getExpirationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expirationDate", expirationDate)
    def getReturnShippingLabelURI: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("returnShippingLabelURI", returnShippingLabelURI)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.DescribeReturnShippingLabelResponse
  ) extends zio.aws.snowball.model.DescribeReturnShippingLabelResponse.ReadOnly {
    override val status: Option[zio.aws.snowball.model.ShippingLabelStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.snowball.model.ShippingLabelStatus.wrap(value))
    override val expirationDate: Option[Timestamp] = scala
      .Option(impl.expirationDate())
      .map(value => zio.aws.snowball.model.primitives.Timestamp(value))
    override val returnShippingLabelURI: Option[String] =
      scala.Option(impl.returnShippingLabelURI()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.DescribeReturnShippingLabelResponse
  ): zio.aws.snowball.model.DescribeReturnShippingLabelResponse.ReadOnly =
    new Wrapper(impl)
}
