package zio.aws.snowball.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeviceConfiguration(
    snowconeDeviceConfiguration: Option[
      zio.aws.snowball.model.SnowconeDeviceConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.DeviceConfiguration = {
    import DeviceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.DeviceConfiguration
      .builder()
      .optionallyWith(
        snowconeDeviceConfiguration.map(value => value.buildAwsValue())
      )(_.snowconeDeviceConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.DeviceConfiguration.ReadOnly =
    zio.aws.snowball.model.DeviceConfiguration.wrap(buildAwsValue())
}
object DeviceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.DeviceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.DeviceConfiguration =
      zio.aws.snowball.model.DeviceConfiguration(
        snowconeDeviceConfiguration.map(value => value.asEditable)
      )
    def snowconeDeviceConfiguration
        : Option[zio.aws.snowball.model.SnowconeDeviceConfiguration.ReadOnly]
    def getSnowconeDeviceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.snowball.model.SnowconeDeviceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "snowconeDeviceConfiguration",
      snowconeDeviceConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.DeviceConfiguration
  ) extends zio.aws.snowball.model.DeviceConfiguration.ReadOnly {
    override val snowconeDeviceConfiguration
        : Option[zio.aws.snowball.model.SnowconeDeviceConfiguration.ReadOnly] =
      scala
        .Option(impl.snowconeDeviceConfiguration())
        .map(value =>
          zio.aws.snowball.model.SnowconeDeviceConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.DeviceConfiguration
  ): zio.aws.snowball.model.DeviceConfiguration.ReadOnly = new Wrapper(impl)
}
