package zio.aws.snowball.model
import scala.jdk.CollectionConverters.*
sealed trait DeviceServiceName {
  def unwrap: software.amazon.awssdk.services.snowball.model.DeviceServiceName
}
object DeviceServiceName {
  def wrap(
      value: software.amazon.awssdk.services.snowball.model.DeviceServiceName
  ): zio.aws.snowball.model.DeviceServiceName = value match {
    case software.amazon.awssdk.services.snowball.model.DeviceServiceName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.snowball.model.DeviceServiceName.NFS_ON_DEVICE_SERVICE =>
      val r = NFS_ON_DEVICE_SERVICE
      r
    case software.amazon.awssdk.services.snowball.model.DeviceServiceName.S3_ON_DEVICE_SERVICE =>
      val r = S3_ON_DEVICE_SERVICE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.snowball.model.DeviceServiceName {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.DeviceServiceName =
      software.amazon.awssdk.services.snowball.model.DeviceServiceName.UNKNOWN_TO_SDK_VERSION
  }
  case object NFS_ON_DEVICE_SERVICE
      extends zio.aws.snowball.model.DeviceServiceName {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.DeviceServiceName =
      software.amazon.awssdk.services.snowball.model.DeviceServiceName.NFS_ON_DEVICE_SERVICE
  }
  case object S3_ON_DEVICE_SERVICE
      extends zio.aws.snowball.model.DeviceServiceName {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.DeviceServiceName =
      software.amazon.awssdk.services.snowball.model.DeviceServiceName.S3_ON_DEVICE_SERVICE
  }
}
