package zio.aws.snowball.model
import zio.aws.snowball.model.primitives.AmiId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Ec2AmiResource(
    amiId: AmiId,
    snowballAmiId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.Ec2AmiResource = {
    import Ec2AmiResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.Ec2AmiResource
      .builder()
      .amiId(AmiId.unwrap(amiId): java.lang.String)
      .optionallyWith(snowballAmiId.map(value => value: java.lang.String))(
        _.snowballAmiId
      )
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.Ec2AmiResource.ReadOnly =
    zio.aws.snowball.model.Ec2AmiResource.wrap(buildAwsValue())
}
object Ec2AmiResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.Ec2AmiResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.Ec2AmiResource =
      zio.aws.snowball.model
        .Ec2AmiResource(amiId, snowballAmiId.map(value => value))
    def amiId: AmiId
    def snowballAmiId: Option[String]
    def getAmiId: ZIO[Any, Nothing, AmiId] = ZIO.succeed(amiId)
    def getSnowballAmiId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snowballAmiId", snowballAmiId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.Ec2AmiResource
  ) extends zio.aws.snowball.model.Ec2AmiResource.ReadOnly {
    override val amiId: AmiId =
      zio.aws.snowball.model.primitives.AmiId(impl.amiId())
    override val snowballAmiId: Option[String] =
      scala.Option(impl.snowballAmiId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.Ec2AmiResource
  ): zio.aws.snowball.model.Ec2AmiResource.ReadOnly = new Wrapper(impl)
}
