package zio.aws.snowball.model
import zio.aws.snowball.model.primitives.ResourceARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EventTriggerDefinition(
    eventResourceARN: Option[ResourceARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.EventTriggerDefinition = {
    import EventTriggerDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.EventTriggerDefinition
      .builder()
      .optionallyWith(
        eventResourceARN.map(value =>
          ResourceARN.unwrap(value): java.lang.String
        )
      )(_.eventResourceARN)
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.EventTriggerDefinition.ReadOnly =
    zio.aws.snowball.model.EventTriggerDefinition.wrap(buildAwsValue())
}
object EventTriggerDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.EventTriggerDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.EventTriggerDefinition =
      zio.aws.snowball.model
        .EventTriggerDefinition(eventResourceARN.map(value => value))
    def eventResourceARN: Option[ResourceARN]
    def getEventResourceARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("eventResourceARN", eventResourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.EventTriggerDefinition
  ) extends zio.aws.snowball.model.EventTriggerDefinition.ReadOnly {
    override val eventResourceARN: Option[ResourceARN] = scala
      .Option(impl.eventResourceARN())
      .map(value => zio.aws.snowball.model.primitives.ResourceARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.EventTriggerDefinition
  ): zio.aws.snowball.model.EventTriggerDefinition.ReadOnly = new Wrapper(impl)
}
