package zio.aws.snowball.model
import zio.aws.snowball.model.primitives.JobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetJobManifestRequest(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.GetJobManifestRequest = {
    import GetJobManifestRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.GetJobManifestRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.GetJobManifestRequest.ReadOnly =
    zio.aws.snowball.model.GetJobManifestRequest.wrap(buildAwsValue())
}
object GetJobManifestRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.GetJobManifestRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.GetJobManifestRequest =
      zio.aws.snowball.model.GetJobManifestRequest(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.GetJobManifestRequest
  ) extends zio.aws.snowball.model.GetJobManifestRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.snowball.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.GetJobManifestRequest
  ): zio.aws.snowball.model.GetJobManifestRequest.ReadOnly = new Wrapper(impl)
}
