package zio.aws.snowball.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetJobManifestResponse(manifestURI: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.GetJobManifestResponse = {
    import GetJobManifestResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.GetJobManifestResponse
      .builder()
      .optionallyWith(manifestURI.map(value => value: java.lang.String))(
        _.manifestURI
      )
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.GetJobManifestResponse.ReadOnly =
    zio.aws.snowball.model.GetJobManifestResponse.wrap(buildAwsValue())
}
object GetJobManifestResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.GetJobManifestResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.GetJobManifestResponse =
      zio.aws.snowball.model
        .GetJobManifestResponse(manifestURI.map(value => value))
    def manifestURI: Option[String]
    def getManifestURI: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("manifestURI", manifestURI)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.GetJobManifestResponse
  ) extends zio.aws.snowball.model.GetJobManifestResponse.ReadOnly {
    override val manifestURI: Option[String] =
      scala.Option(impl.manifestURI()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.GetJobManifestResponse
  ): zio.aws.snowball.model.GetJobManifestResponse.ReadOnly = new Wrapper(impl)
}
