package zio.aws.snowball.model
import zio.aws.snowball.model.primitives.JobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetJobUnlockCodeRequest(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.GetJobUnlockCodeRequest = {
    import GetJobUnlockCodeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.GetJobUnlockCodeRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.GetJobUnlockCodeRequest.ReadOnly =
    zio.aws.snowball.model.GetJobUnlockCodeRequest.wrap(buildAwsValue())
}
object GetJobUnlockCodeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.GetJobUnlockCodeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.GetJobUnlockCodeRequest =
      zio.aws.snowball.model.GetJobUnlockCodeRequest(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.GetJobUnlockCodeRequest
  ) extends zio.aws.snowball.model.GetJobUnlockCodeRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.snowball.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.GetJobUnlockCodeRequest
  ): zio.aws.snowball.model.GetJobUnlockCodeRequest.ReadOnly = new Wrapper(impl)
}
