package zio.aws.snowball.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetJobUnlockCodeResponse(unlockCode: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.GetJobUnlockCodeResponse = {
    import GetJobUnlockCodeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.GetJobUnlockCodeResponse
      .builder()
      .optionallyWith(unlockCode.map(value => value: java.lang.String))(
        _.unlockCode
      )
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.GetJobUnlockCodeResponse.ReadOnly =
    zio.aws.snowball.model.GetJobUnlockCodeResponse.wrap(buildAwsValue())
}
object GetJobUnlockCodeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.GetJobUnlockCodeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.GetJobUnlockCodeResponse =
      zio.aws.snowball.model
        .GetJobUnlockCodeResponse(unlockCode.map(value => value))
    def unlockCode: Option[String]
    def getUnlockCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("unlockCode", unlockCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.GetJobUnlockCodeResponse
  ) extends zio.aws.snowball.model.GetJobUnlockCodeResponse.ReadOnly {
    override val unlockCode: Option[String] =
      scala.Option(impl.unlockCode()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.GetJobUnlockCodeResponse
  ): zio.aws.snowball.model.GetJobUnlockCodeResponse.ReadOnly = new Wrapper(
    impl
  )
}
