package zio.aws.snowball.model
import zio.aws.snowball.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetSnowballUsageResponse(
    snowballLimit: Option[Integer] = None,
    snowballsInUse: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.GetSnowballUsageResponse = {
    import GetSnowballUsageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.GetSnowballUsageResponse
      .builder()
      .optionallyWith(
        snowballLimit.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.snowballLimit)
      .optionallyWith(
        snowballsInUse.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.snowballsInUse)
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.GetSnowballUsageResponse.ReadOnly =
    zio.aws.snowball.model.GetSnowballUsageResponse.wrap(buildAwsValue())
}
object GetSnowballUsageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.GetSnowballUsageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.GetSnowballUsageResponse =
      zio.aws.snowball.model.GetSnowballUsageResponse(
        snowballLimit.map(value => value),
        snowballsInUse.map(value => value)
      )
    def snowballLimit: Option[Integer]
    def snowballsInUse: Option[Integer]
    def getSnowballLimit: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("snowballLimit", snowballLimit)
    def getSnowballsInUse: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("snowballsInUse", snowballsInUse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.GetSnowballUsageResponse
  ) extends zio.aws.snowball.model.GetSnowballUsageResponse.ReadOnly {
    override val snowballLimit: Option[Integer] = scala
      .Option(impl.snowballLimit())
      .map(value => zio.aws.snowball.model.primitives.Integer(value))
    override val snowballsInUse: Option[Integer] = scala
      .Option(impl.snowballsInUse())
      .map(value => zio.aws.snowball.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.GetSnowballUsageResponse
  ): zio.aws.snowball.model.GetSnowballUsageResponse.ReadOnly = new Wrapper(
    impl
  )
}
