package zio.aws.snowball.model
import zio.aws.snowball.model.primitives.JobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetSoftwareUpdatesRequest(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.GetSoftwareUpdatesRequest = {
    import GetSoftwareUpdatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.GetSoftwareUpdatesRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.GetSoftwareUpdatesRequest.ReadOnly =
    zio.aws.snowball.model.GetSoftwareUpdatesRequest.wrap(buildAwsValue())
}
object GetSoftwareUpdatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.GetSoftwareUpdatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.GetSoftwareUpdatesRequest =
      zio.aws.snowball.model.GetSoftwareUpdatesRequest(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.GetSoftwareUpdatesRequest
  ) extends zio.aws.snowball.model.GetSoftwareUpdatesRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.snowball.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.GetSoftwareUpdatesRequest
  ): zio.aws.snowball.model.GetSoftwareUpdatesRequest.ReadOnly = new Wrapper(
    impl
  )
}
