package zio.aws.snowball.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetSoftwareUpdatesResponse(updatesURI: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.GetSoftwareUpdatesResponse = {
    import GetSoftwareUpdatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.GetSoftwareUpdatesResponse
      .builder()
      .optionallyWith(updatesURI.map(value => value: java.lang.String))(
        _.updatesURI
      )
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.GetSoftwareUpdatesResponse.ReadOnly =
    zio.aws.snowball.model.GetSoftwareUpdatesResponse.wrap(buildAwsValue())
}
object GetSoftwareUpdatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.GetSoftwareUpdatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.GetSoftwareUpdatesResponse =
      zio.aws.snowball.model
        .GetSoftwareUpdatesResponse(updatesURI.map(value => value))
    def updatesURI: Option[String]
    def getUpdatesURI: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("updatesURI", updatesURI)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.GetSoftwareUpdatesResponse
  ) extends zio.aws.snowball.model.GetSoftwareUpdatesResponse.ReadOnly {
    override val updatesURI: Option[String] =
      scala.Option(impl.updatesURI()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.GetSoftwareUpdatesResponse
  ): zio.aws.snowball.model.GetSoftwareUpdatesResponse.ReadOnly = new Wrapper(
    impl
  )
}
