package zio.aws.snowball.model
import zio.aws.snowball.model.primitives.GSTIN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class INDTaxDocuments(gstin: Option[GSTIN] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.INDTaxDocuments = {
    import INDTaxDocuments.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.INDTaxDocuments
      .builder()
      .optionallyWith(
        gstin.map(value => GSTIN.unwrap(value): java.lang.String)
      )(_.gstin)
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.INDTaxDocuments.ReadOnly =
    zio.aws.snowball.model.INDTaxDocuments.wrap(buildAwsValue())
}
object INDTaxDocuments {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.INDTaxDocuments
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.INDTaxDocuments =
      zio.aws.snowball.model.INDTaxDocuments(gstin.map(value => value))
    def gstin: Option[GSTIN]
    def getGstin: ZIO[Any, AwsError, GSTIN] =
      AwsError.unwrapOptionField("gstin", gstin)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.INDTaxDocuments
  ) extends zio.aws.snowball.model.INDTaxDocuments.ReadOnly {
    override val gstin: Option[GSTIN] = scala
      .Option(impl.gstin())
      .map(value => zio.aws.snowball.model.primitives.GSTIN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.INDTaxDocuments
  ): zio.aws.snowball.model.INDTaxDocuments.ReadOnly = new Wrapper(impl)
}
