package zio.aws.snowball.model
import zio.aws.snowball.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class JobListEntry(
    jobId: Option[String] = None,
    jobState: Option[zio.aws.snowball.model.JobState] = None,
    isMaster: Option[Boolean] = None,
    jobType: Option[zio.aws.snowball.model.JobType] = None,
    snowballType: Option[zio.aws.snowball.model.SnowballType] = None,
    creationDate: Option[Timestamp] = None,
    description: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.JobListEntry = {
    import JobListEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.JobListEntry
      .builder()
      .optionallyWith(jobId.map(value => value: java.lang.String))(_.jobId)
      .optionallyWith(jobState.map(value => value.unwrap))(_.jobState)
      .optionallyWith(isMaster.map(value => value: java.lang.Boolean))(
        _.isMaster
      )
      .optionallyWith(jobType.map(value => value.unwrap))(_.jobType)
      .optionallyWith(snowballType.map(value => value.unwrap))(_.snowballType)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.JobListEntry.ReadOnly =
    zio.aws.snowball.model.JobListEntry.wrap(buildAwsValue())
}
object JobListEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.JobListEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.JobListEntry =
      zio.aws.snowball.model.JobListEntry(
        jobId.map(value => value),
        jobState.map(value => value),
        isMaster.map(value => value),
        jobType.map(value => value),
        snowballType.map(value => value),
        creationDate.map(value => value),
        description.map(value => value)
      )
    def jobId: Option[String]
    def jobState: Option[zio.aws.snowball.model.JobState]
    def isMaster: Option[Boolean]
    def jobType: Option[zio.aws.snowball.model.JobType]
    def snowballType: Option[zio.aws.snowball.model.SnowballType]
    def creationDate: Option[Timestamp]
    def description: Option[String]
    def getJobId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getJobState: ZIO[Any, AwsError, zio.aws.snowball.model.JobState] =
      AwsError.unwrapOptionField("jobState", jobState)
    def getIsMaster: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isMaster", isMaster)
    def getJobType: ZIO[Any, AwsError, zio.aws.snowball.model.JobType] =
      AwsError.unwrapOptionField("jobType", jobType)
    def getSnowballType
        : ZIO[Any, AwsError, zio.aws.snowball.model.SnowballType] =
      AwsError.unwrapOptionField("snowballType", snowballType)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.JobListEntry
  ) extends zio.aws.snowball.model.JobListEntry.ReadOnly {
    override val jobId: Option[String] =
      scala.Option(impl.jobId()).map(value => value: String)
    override val jobState: Option[zio.aws.snowball.model.JobState] = scala
      .Option(impl.jobState())
      .map(value => zio.aws.snowball.model.JobState.wrap(value))
    override val isMaster: Option[Boolean] =
      scala.Option(impl.isMaster()).map(value => value: Boolean)
    override val jobType: Option[zio.aws.snowball.model.JobType] = scala
      .Option(impl.jobType())
      .map(value => zio.aws.snowball.model.JobType.wrap(value))
    override val snowballType: Option[zio.aws.snowball.model.SnowballType] =
      scala
        .Option(impl.snowballType())
        .map(value => zio.aws.snowball.model.SnowballType.wrap(value))
    override val creationDate: Option[Timestamp] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.snowball.model.primitives.Timestamp(value))
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.JobListEntry
  ): zio.aws.snowball.model.JobListEntry.ReadOnly = new Wrapper(impl)
}
