package zio.aws.snowball.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class JobLogs(
    jobCompletionReportURI: Option[String] = None,
    jobSuccessLogURI: Option[String] = None,
    jobFailureLogURI: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.JobLogs = {
    import JobLogs.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.JobLogs
      .builder()
      .optionallyWith(
        jobCompletionReportURI.map(value => value: java.lang.String)
      )(_.jobCompletionReportURI)
      .optionallyWith(jobSuccessLogURI.map(value => value: java.lang.String))(
        _.jobSuccessLogURI
      )
      .optionallyWith(jobFailureLogURI.map(value => value: java.lang.String))(
        _.jobFailureLogURI
      )
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.JobLogs.ReadOnly =
    zio.aws.snowball.model.JobLogs.wrap(buildAwsValue())
}
object JobLogs {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.snowball.model.JobLogs] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.JobLogs =
      zio.aws.snowball.model.JobLogs(
        jobCompletionReportURI.map(value => value),
        jobSuccessLogURI.map(value => value),
        jobFailureLogURI.map(value => value)
      )
    def jobCompletionReportURI: Option[String]
    def jobSuccessLogURI: Option[String]
    def jobFailureLogURI: Option[String]
    def getJobCompletionReportURI: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("jobCompletionReportURI", jobCompletionReportURI)
    def getJobSuccessLogURI: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("jobSuccessLogURI", jobSuccessLogURI)
    def getJobFailureLogURI: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("jobFailureLogURI", jobFailureLogURI)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.JobLogs
  ) extends zio.aws.snowball.model.JobLogs.ReadOnly {
    override val jobCompletionReportURI: Option[String] =
      scala.Option(impl.jobCompletionReportURI()).map(value => value: String)
    override val jobSuccessLogURI: Option[String] =
      scala.Option(impl.jobSuccessLogURI()).map(value => value: String)
    override val jobFailureLogURI: Option[String] =
      scala.Option(impl.jobFailureLogURI()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.JobLogs
  ): zio.aws.snowball.model.JobLogs.ReadOnly = new Wrapper(impl)
}
