package zio.aws.snowball.model
import zio.aws.snowball.model.primitives.{
  KmsKeyARN,
  Timestamp,
  AddressId,
  RoleARN,
  LongTermPricingId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class JobMetadata(
    jobId: Option[String] = None,
    jobState: Option[zio.aws.snowball.model.JobState] = None,
    jobType: Option[zio.aws.snowball.model.JobType] = None,
    snowballType: Option[zio.aws.snowball.model.SnowballType] = None,
    creationDate: Option[Timestamp] = None,
    resources: Option[zio.aws.snowball.model.JobResource] = None,
    description: Option[String] = None,
    kmsKeyARN: Option[KmsKeyARN] = None,
    roleARN: Option[RoleARN] = None,
    addressId: Option[AddressId] = None,
    shippingDetails: Option[zio.aws.snowball.model.ShippingDetails] = None,
    snowballCapacityPreference: Option[
      zio.aws.snowball.model.SnowballCapacity
    ] = None,
    notification: Option[zio.aws.snowball.model.Notification] = None,
    dataTransferProgress: Option[zio.aws.snowball.model.DataTransfer] = None,
    jobLogInfo: Option[zio.aws.snowball.model.JobLogs] = None,
    clusterId: Option[String] = None,
    forwardingAddressId: Option[AddressId] = None,
    taxDocuments: Option[zio.aws.snowball.model.TaxDocuments] = None,
    deviceConfiguration: Option[zio.aws.snowball.model.DeviceConfiguration] =
      None,
    remoteManagement: Option[zio.aws.snowball.model.RemoteManagement] = None,
    longTermPricingId: Option[LongTermPricingId] = None,
    onDeviceServiceConfiguration: Option[
      zio.aws.snowball.model.OnDeviceServiceConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.JobMetadata = {
    import JobMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.JobMetadata
      .builder()
      .optionallyWith(jobId.map(value => value: java.lang.String))(_.jobId)
      .optionallyWith(jobState.map(value => value.unwrap))(_.jobState)
      .optionallyWith(jobType.map(value => value.unwrap))(_.jobType)
      .optionallyWith(snowballType.map(value => value.unwrap))(_.snowballType)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(resources.map(value => value.buildAwsValue()))(
        _.resources
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        kmsKeyARN.map(value => KmsKeyARN.unwrap(value): java.lang.String)
      )(_.kmsKeyARN)
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .optionallyWith(
        addressId.map(value => AddressId.unwrap(value): java.lang.String)
      )(_.addressId)
      .optionallyWith(shippingDetails.map(value => value.buildAwsValue()))(
        _.shippingDetails
      )
      .optionallyWith(snowballCapacityPreference.map(value => value.unwrap))(
        _.snowballCapacityPreference
      )
      .optionallyWith(notification.map(value => value.buildAwsValue()))(
        _.notification
      )
      .optionallyWith(dataTransferProgress.map(value => value.buildAwsValue()))(
        _.dataTransferProgress
      )
      .optionallyWith(jobLogInfo.map(value => value.buildAwsValue()))(
        _.jobLogInfo
      )
      .optionallyWith(clusterId.map(value => value: java.lang.String))(
        _.clusterId
      )
      .optionallyWith(
        forwardingAddressId.map(value =>
          AddressId.unwrap(value): java.lang.String
        )
      )(_.forwardingAddressId)
      .optionallyWith(taxDocuments.map(value => value.buildAwsValue()))(
        _.taxDocuments
      )
      .optionallyWith(deviceConfiguration.map(value => value.buildAwsValue()))(
        _.deviceConfiguration
      )
      .optionallyWith(remoteManagement.map(value => value.unwrap))(
        _.remoteManagement
      )
      .optionallyWith(
        longTermPricingId.map(value =>
          LongTermPricingId.unwrap(value): java.lang.String
        )
      )(_.longTermPricingId)
      .optionallyWith(
        onDeviceServiceConfiguration.map(value => value.buildAwsValue())
      )(_.onDeviceServiceConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.JobMetadata.ReadOnly =
    zio.aws.snowball.model.JobMetadata.wrap(buildAwsValue())
}
object JobMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.JobMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.JobMetadata =
      zio.aws.snowball.model.JobMetadata(
        jobId.map(value => value),
        jobState.map(value => value),
        jobType.map(value => value),
        snowballType.map(value => value),
        creationDate.map(value => value),
        resources.map(value => value.asEditable),
        description.map(value => value),
        kmsKeyARN.map(value => value),
        roleARN.map(value => value),
        addressId.map(value => value),
        shippingDetails.map(value => value.asEditable),
        snowballCapacityPreference.map(value => value),
        notification.map(value => value.asEditable),
        dataTransferProgress.map(value => value.asEditable),
        jobLogInfo.map(value => value.asEditable),
        clusterId.map(value => value),
        forwardingAddressId.map(value => value),
        taxDocuments.map(value => value.asEditable),
        deviceConfiguration.map(value => value.asEditable),
        remoteManagement.map(value => value),
        longTermPricingId.map(value => value),
        onDeviceServiceConfiguration.map(value => value.asEditable)
      )
    def jobId: Option[String]
    def jobState: Option[zio.aws.snowball.model.JobState]
    def jobType: Option[zio.aws.snowball.model.JobType]
    def snowballType: Option[zio.aws.snowball.model.SnowballType]
    def creationDate: Option[Timestamp]
    def resources: Option[zio.aws.snowball.model.JobResource.ReadOnly]
    def description: Option[String]
    def kmsKeyARN: Option[KmsKeyARN]
    def roleARN: Option[RoleARN]
    def addressId: Option[AddressId]
    def shippingDetails: Option[zio.aws.snowball.model.ShippingDetails.ReadOnly]
    def snowballCapacityPreference
        : Option[zio.aws.snowball.model.SnowballCapacity]
    def notification: Option[zio.aws.snowball.model.Notification.ReadOnly]
    def dataTransferProgress
        : Option[zio.aws.snowball.model.DataTransfer.ReadOnly]
    def jobLogInfo: Option[zio.aws.snowball.model.JobLogs.ReadOnly]
    def clusterId: Option[String]
    def forwardingAddressId: Option[AddressId]
    def taxDocuments: Option[zio.aws.snowball.model.TaxDocuments.ReadOnly]
    def deviceConfiguration
        : Option[zio.aws.snowball.model.DeviceConfiguration.ReadOnly]
    def remoteManagement: Option[zio.aws.snowball.model.RemoteManagement]
    def longTermPricingId: Option[LongTermPricingId]
    def onDeviceServiceConfiguration
        : Option[zio.aws.snowball.model.OnDeviceServiceConfiguration.ReadOnly]
    def getJobId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getJobState: ZIO[Any, AwsError, zio.aws.snowball.model.JobState] =
      AwsError.unwrapOptionField("jobState", jobState)
    def getJobType: ZIO[Any, AwsError, zio.aws.snowball.model.JobType] =
      AwsError.unwrapOptionField("jobType", jobType)
    def getSnowballType
        : ZIO[Any, AwsError, zio.aws.snowball.model.SnowballType] =
      AwsError.unwrapOptionField("snowballType", snowballType)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getResources
        : ZIO[Any, AwsError, zio.aws.snowball.model.JobResource.ReadOnly] =
      AwsError.unwrapOptionField("resources", resources)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getKmsKeyARN: ZIO[Any, AwsError, KmsKeyARN] =
      AwsError.unwrapOptionField("kmsKeyARN", kmsKeyARN)
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getAddressId: ZIO[Any, AwsError, AddressId] =
      AwsError.unwrapOptionField("addressId", addressId)
    def getShippingDetails
        : ZIO[Any, AwsError, zio.aws.snowball.model.ShippingDetails.ReadOnly] =
      AwsError.unwrapOptionField("shippingDetails", shippingDetails)
    def getSnowballCapacityPreference
        : ZIO[Any, AwsError, zio.aws.snowball.model.SnowballCapacity] =
      AwsError.unwrapOptionField(
        "snowballCapacityPreference",
        snowballCapacityPreference
      )
    def getNotification
        : ZIO[Any, AwsError, zio.aws.snowball.model.Notification.ReadOnly] =
      AwsError.unwrapOptionField("notification", notification)
    def getDataTransferProgress
        : ZIO[Any, AwsError, zio.aws.snowball.model.DataTransfer.ReadOnly] =
      AwsError.unwrapOptionField("dataTransferProgress", dataTransferProgress)
    def getJobLogInfo
        : ZIO[Any, AwsError, zio.aws.snowball.model.JobLogs.ReadOnly] =
      AwsError.unwrapOptionField("jobLogInfo", jobLogInfo)
    def getClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterId", clusterId)
    def getForwardingAddressId: ZIO[Any, AwsError, AddressId] =
      AwsError.unwrapOptionField("forwardingAddressId", forwardingAddressId)
    def getTaxDocuments
        : ZIO[Any, AwsError, zio.aws.snowball.model.TaxDocuments.ReadOnly] =
      AwsError.unwrapOptionField("taxDocuments", taxDocuments)
    def getDeviceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.snowball.model.DeviceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("deviceConfiguration", deviceConfiguration)
    def getRemoteManagement
        : ZIO[Any, AwsError, zio.aws.snowball.model.RemoteManagement] =
      AwsError.unwrapOptionField("remoteManagement", remoteManagement)
    def getLongTermPricingId: ZIO[Any, AwsError, LongTermPricingId] =
      AwsError.unwrapOptionField("longTermPricingId", longTermPricingId)
    def getOnDeviceServiceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.snowball.model.OnDeviceServiceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "onDeviceServiceConfiguration",
      onDeviceServiceConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.JobMetadata
  ) extends zio.aws.snowball.model.JobMetadata.ReadOnly {
    override val jobId: Option[String] =
      scala.Option(impl.jobId()).map(value => value: String)
    override val jobState: Option[zio.aws.snowball.model.JobState] = scala
      .Option(impl.jobState())
      .map(value => zio.aws.snowball.model.JobState.wrap(value))
    override val jobType: Option[zio.aws.snowball.model.JobType] = scala
      .Option(impl.jobType())
      .map(value => zio.aws.snowball.model.JobType.wrap(value))
    override val snowballType: Option[zio.aws.snowball.model.SnowballType] =
      scala
        .Option(impl.snowballType())
        .map(value => zio.aws.snowball.model.SnowballType.wrap(value))
    override val creationDate: Option[Timestamp] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.snowball.model.primitives.Timestamp(value))
    override val resources
        : Option[zio.aws.snowball.model.JobResource.ReadOnly] = scala
      .Option(impl.resources())
      .map(value => zio.aws.snowball.model.JobResource.wrap(value))
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val kmsKeyARN: Option[KmsKeyARN] = scala
      .Option(impl.kmsKeyARN())
      .map(value => zio.aws.snowball.model.primitives.KmsKeyARN(value))
    override val roleARN: Option[RoleARN] = scala
      .Option(impl.roleARN())
      .map(value => zio.aws.snowball.model.primitives.RoleARN(value))
    override val addressId: Option[AddressId] = scala
      .Option(impl.addressId())
      .map(value => zio.aws.snowball.model.primitives.AddressId(value))
    override val shippingDetails
        : Option[zio.aws.snowball.model.ShippingDetails.ReadOnly] = scala
      .Option(impl.shippingDetails())
      .map(value => zio.aws.snowball.model.ShippingDetails.wrap(value))
    override val snowballCapacityPreference
        : Option[zio.aws.snowball.model.SnowballCapacity] = scala
      .Option(impl.snowballCapacityPreference())
      .map(value => zio.aws.snowball.model.SnowballCapacity.wrap(value))
    override val notification
        : Option[zio.aws.snowball.model.Notification.ReadOnly] = scala
      .Option(impl.notification())
      .map(value => zio.aws.snowball.model.Notification.wrap(value))
    override val dataTransferProgress
        : Option[zio.aws.snowball.model.DataTransfer.ReadOnly] = scala
      .Option(impl.dataTransferProgress())
      .map(value => zio.aws.snowball.model.DataTransfer.wrap(value))
    override val jobLogInfo: Option[zio.aws.snowball.model.JobLogs.ReadOnly] =
      scala
        .Option(impl.jobLogInfo())
        .map(value => zio.aws.snowball.model.JobLogs.wrap(value))
    override val clusterId: Option[String] =
      scala.Option(impl.clusterId()).map(value => value: String)
    override val forwardingAddressId: Option[AddressId] = scala
      .Option(impl.forwardingAddressId())
      .map(value => zio.aws.snowball.model.primitives.AddressId(value))
    override val taxDocuments
        : Option[zio.aws.snowball.model.TaxDocuments.ReadOnly] = scala
      .Option(impl.taxDocuments())
      .map(value => zio.aws.snowball.model.TaxDocuments.wrap(value))
    override val deviceConfiguration
        : Option[zio.aws.snowball.model.DeviceConfiguration.ReadOnly] = scala
      .Option(impl.deviceConfiguration())
      .map(value => zio.aws.snowball.model.DeviceConfiguration.wrap(value))
    override val remoteManagement
        : Option[zio.aws.snowball.model.RemoteManagement] = scala
      .Option(impl.remoteManagement())
      .map(value => zio.aws.snowball.model.RemoteManagement.wrap(value))
    override val longTermPricingId: Option[LongTermPricingId] = scala
      .Option(impl.longTermPricingId())
      .map(value => zio.aws.snowball.model.primitives.LongTermPricingId(value))
    override val onDeviceServiceConfiguration
        : Option[zio.aws.snowball.model.OnDeviceServiceConfiguration.ReadOnly] =
      scala
        .Option(impl.onDeviceServiceConfiguration())
        .map(value =>
          zio.aws.snowball.model.OnDeviceServiceConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.JobMetadata
  ): zio.aws.snowball.model.JobMetadata.ReadOnly = new Wrapper(impl)
}
