package zio.aws.snowball.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class JobResource(
    s3Resources: Option[Iterable[zio.aws.snowball.model.S3Resource]] = None,
    lambdaResources: Option[Iterable[zio.aws.snowball.model.LambdaResource]] =
      None,
    ec2AmiResources: Option[Iterable[zio.aws.snowball.model.Ec2AmiResource]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.snowball.model.JobResource = {
    import JobResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.snowball.model.JobResource
      .builder()
      .optionallyWith(
        s3Resources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.s3Resources)
      .optionallyWith(
        lambdaResources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lambdaResources)
      .optionallyWith(
        ec2AmiResources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ec2AmiResources)
      .build()
  }
  def asReadOnly: zio.aws.snowball.model.JobResource.ReadOnly =
    zio.aws.snowball.model.JobResource.wrap(buildAwsValue())
}
object JobResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.snowball.model.JobResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.snowball.model.JobResource =
      zio.aws.snowball.model.JobResource(
        s3Resources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lambdaResources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ec2AmiResources.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def s3Resources: Option[List[zio.aws.snowball.model.S3Resource.ReadOnly]]
    def lambdaResources
        : Option[List[zio.aws.snowball.model.LambdaResource.ReadOnly]]
    def ec2AmiResources
        : Option[List[zio.aws.snowball.model.Ec2AmiResource.ReadOnly]]
    def getS3Resources
        : ZIO[Any, AwsError, List[zio.aws.snowball.model.S3Resource.ReadOnly]] =
      AwsError.unwrapOptionField("s3Resources", s3Resources)
    def getLambdaResources: ZIO[Any, AwsError, List[
      zio.aws.snowball.model.LambdaResource.ReadOnly
    ]] = AwsError.unwrapOptionField("lambdaResources", lambdaResources)
    def getEc2AmiResources: ZIO[Any, AwsError, List[
      zio.aws.snowball.model.Ec2AmiResource.ReadOnly
    ]] = AwsError.unwrapOptionField("ec2AmiResources", ec2AmiResources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.snowball.model.JobResource
  ) extends zio.aws.snowball.model.JobResource.ReadOnly {
    override val s3Resources
        : Option[List[zio.aws.snowball.model.S3Resource.ReadOnly]] = scala
      .Option(impl.s3Resources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.snowball.model.S3Resource.wrap(item)
        }.toList
      )
    override val lambdaResources
        : Option[List[zio.aws.snowball.model.LambdaResource.ReadOnly]] = scala
      .Option(impl.lambdaResources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.snowball.model.LambdaResource.wrap(item)
        }.toList
      )
    override val ec2AmiResources
        : Option[List[zio.aws.snowball.model.Ec2AmiResource.ReadOnly]] = scala
      .Option(impl.ec2AmiResources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.snowball.model.Ec2AmiResource.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.snowball.model.JobResource
  ): zio.aws.snowball.model.JobResource.ReadOnly = new Wrapper(impl)
}
