package zio.aws.snowball.model
import scala.jdk.CollectionConverters.*
sealed trait JobState {
  def unwrap: software.amazon.awssdk.services.snowball.model.JobState
}
object JobState {
  def wrap(
      value: software.amazon.awssdk.services.snowball.model.JobState
  ): zio.aws.snowball.model.JobState = value match {
    case software.amazon.awssdk.services.snowball.model.JobState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.snowball.model.JobState.NEW =>
      val r = New
      r
    case software.amazon.awssdk.services.snowball.model.JobState.PREPARING_APPLIANCE =>
      val r = PreparingAppliance
      r
    case software.amazon.awssdk.services.snowball.model.JobState.PREPARING_SHIPMENT =>
      val r = PreparingShipment
      r
    case software.amazon.awssdk.services.snowball.model.JobState.IN_TRANSIT_TO_CUSTOMER =>
      val r = InTransitToCustomer
      r
    case software.amazon.awssdk.services.snowball.model.JobState.WITH_CUSTOMER =>
      val r = WithCustomer
      r
    case software.amazon.awssdk.services.snowball.model.JobState.IN_TRANSIT_TO_AWS =>
      val r = InTransitToAWS
      r
    case software.amazon.awssdk.services.snowball.model.JobState.WITH_AWS_SORTING_FACILITY =>
      val r = WithAWSSortingFacility
      r
    case software.amazon.awssdk.services.snowball.model.JobState.WITH_AWS =>
      val r = WithAWS
      r
    case software.amazon.awssdk.services.snowball.model.JobState.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.snowball.model.JobState.COMPLETE =>
      val r = Complete
      r
    case software.amazon.awssdk.services.snowball.model.JobState.CANCELLED =>
      val r = Cancelled
      r
    case software.amazon.awssdk.services.snowball.model.JobState.LISTING =>
      val r = Listing
      r
    case software.amazon.awssdk.services.snowball.model.JobState.PENDING =>
      val r = Pending
      r
  }
  case object unknownToSdkVersion extends zio.aws.snowball.model.JobState {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.JobState =
      software.amazon.awssdk.services.snowball.model.JobState.UNKNOWN_TO_SDK_VERSION
  }
  case object New extends zio.aws.snowball.model.JobState {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.JobState =
      software.amazon.awssdk.services.snowball.model.JobState.NEW
  }
  case object PreparingAppliance extends zio.aws.snowball.model.JobState {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.JobState =
      software.amazon.awssdk.services.snowball.model.JobState.PREPARING_APPLIANCE
  }
  case object PreparingShipment extends zio.aws.snowball.model.JobState {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.JobState =
      software.amazon.awssdk.services.snowball.model.JobState.PREPARING_SHIPMENT
  }
  case object InTransitToCustomer extends zio.aws.snowball.model.JobState {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.JobState =
      software.amazon.awssdk.services.snowball.model.JobState.IN_TRANSIT_TO_CUSTOMER
  }
  case object WithCustomer extends zio.aws.snowball.model.JobState {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.JobState =
      software.amazon.awssdk.services.snowball.model.JobState.WITH_CUSTOMER
  }
  case object InTransitToAWS extends zio.aws.snowball.model.JobState {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.JobState =
      software.amazon.awssdk.services.snowball.model.JobState.IN_TRANSIT_TO_AWS
  }
  case object WithAWSSortingFacility extends zio.aws.snowball.model.JobState {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.JobState =
      software.amazon.awssdk.services.snowball.model.JobState.WITH_AWS_SORTING_FACILITY
  }
  case object WithAWS extends zio.aws.snowball.model.JobState {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.JobState =
      software.amazon.awssdk.services.snowball.model.JobState.WITH_AWS
  }
  case object InProgress extends zio.aws.snowball.model.JobState {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.JobState =
      software.amazon.awssdk.services.snowball.model.JobState.IN_PROGRESS
  }
  case object Complete extends zio.aws.snowball.model.JobState {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.JobState =
      software.amazon.awssdk.services.snowball.model.JobState.COMPLETE
  }
  case object Cancelled extends zio.aws.snowball.model.JobState {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.JobState =
      software.amazon.awssdk.services.snowball.model.JobState.CANCELLED
  }
  case object Listing extends zio.aws.snowball.model.JobState {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.JobState =
      software.amazon.awssdk.services.snowball.model.JobState.LISTING
  }
  case object Pending extends zio.aws.snowball.model.JobState {
    override def unwrap
        : software.amazon.awssdk.services.snowball.model.JobState =
      software.amazon.awssdk.services.snowball.model.JobState.PENDING
  }
}
